/*
 * Decompiled with CFR 0.152.
 */
package com.appzilo.sdk.video;

import android.arch.lifecycle.LifecycleObserver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.view.ContextThemeWrapper;
import android.view.View;
import com.appzilo.sdk.video.CustomVideoUIController;
import com.appzilo.sdk.video.R;
import com.appzilo.sdk.video.backend.GigsApi;
import com.appzilo.sdk.video.backend.NoticeApi;
import com.appzilo.sdk.video.backend.model.EmbedGigsResponse;
import com.appzilo.sdk.video.backend.model.NoticeResponse;
import com.appzilo.sdk.video.core.BackgroundWorker;
import com.appzilo.sdk.video.core.Error;
import com.appzilo.sdk.video.core.Result;
import com.appzilo.sdk.video.player.VideoPlayer;
import com.appzilo.sdk.video.player.VideoPlayerView;
import com.appzilo.sdk.video.player.listeners.VideoPlayerInitListener;
import com.appzilo.sdk.video.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class EmbedVideoActivity
extends AppCompatActivity
implements CustomVideoUIController.Listener,
BackgroundWorker.Callbacks,
VideoPlayerInitListener {
    private static final String TASK_GET_YT = "youtube_task_init";
    private static final String TASK_VERIFY_YT = "youtube_task_verify";
    private static final String TASK_GET_POLICE = "youtube_task_get_police";
    private static final String TASK_REPORT_YOUTUBE = "youtube_task_report";
    private static final String TASK_REQUEST_NOTICE = "task_request_notice";
    private static final String OBJ_GIGS_BACKEND = "gigs_backend.youtube";
    private static final String OBJ_NOTICE_API = "obj_notice_api";
    private static final String QUERY_PARAMS = "query_params";
    private View mCustomPlayerUI;
    private BackgroundWorker mWorker;
    private GigsApi mGigsBackend;
    private CustomVideoUIController mCustomPlayerUIController;
    private AlertDialog mNoVideoDialog;
    private ArrayList<EmbedGigsResponse> mPoliceVideoResponse;
    private boolean mIsPolice;
    private VideoPlayerView mYouTubePlayerView;
    private NoticeResponse mNoticeResponse;
    private EmbedGigsResponse mVideoGigsResponse;
    private String mQuery;
    private Bundle mQueryBundle;
    private NoticeApi mNoticeApi;

    protected void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
        this.setContentView(R.layout.activity_embed_video);
        this.mYouTubePlayerView = (VideoPlayerView)this.findViewById(R.id.player);
        this.getLifecycle().addObserver((LifecycleObserver)this.mYouTubePlayerView);
        this.mCustomPlayerUI = this.mYouTubePlayerView.inflateCustomPlayerUI(R.layout.custom_video_ui);
        this.mWorker = new BackgroundWorker((FragmentActivity)this);
        this.mGigsBackend = (GigsApi)this.mWorker.get(OBJ_GIGS_BACKEND);
        if (this.mGigsBackend == null) {
            this.mGigsBackend = new GigsApi((Context)this);
            this.mWorker.put(OBJ_GIGS_BACKEND, this.mGigsBackend);
        }
        this.mNoticeResponse = NoticeApi.getNoticeResponse(this.getApplicationContext());
        if (this.mNoticeApi == null) {
            this.mNoticeApi = new NoticeApi(this.getApplicationContext());
            this.mWorker.put(OBJ_NOTICE_API, this.mNoticeApi);
        }
        this.mQuery = this.getIntent().getStringExtra("video_params");
        if (this.mQuery != null && !this.mQuery.isEmpty()) {
            this.mQueryBundle = new Bundle();
            this.mQueryBundle.putString(QUERY_PARAMS, this.mQuery);
            this.mWorker.executeTask(TASK_REQUEST_NOTICE, this.mQueryBundle, this);
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.mCustomPlayerUIController != null) {
            this.mCustomPlayerUIController.onResume();
        }
    }

    protected void onPause() {
        super.onPause();
        if (this.mCustomPlayerUIController != null) {
            this.mCustomPlayerUIController.onPause();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mCustomPlayerUIController != null) {
            this.mCustomPlayerUIController.onDestroy();
        }
        if (this.isFinishing()) {
            this.setRequestedOrientation(1);
        }
    }

    @Override
    public void onInitSuccess(@NonNull VideoPlayer videoPlayer) {
        if (this.mCustomPlayerUIController == null) {
            this.mCustomPlayerUIController = new CustomVideoUIController((Context)this, this.mCustomPlayerUI, videoPlayer, this.mYouTubePlayerView, this.mNoticeResponse != null ? this.mNoticeResponse.passive_video_interval * 1000 : 0, this.mIsPolice);
            videoPlayer.addListener(this.mCustomPlayerUIController);
        }
    }

    @Override
    public Result executeTaskInBackground(String string2, Bundle bundle) {
        if (bundle == null) {
            bundle = new Bundle();
        }
        bundle.putBoolean("is_featured", Boolean.valueOf(this.getIntent().getStringExtra("is_featured")).booleanValue());
        bundle.putInt("video_category", Integer.valueOf(this.getIntent().getStringExtra("video_category")).intValue());
        switch (string2) {
            case "youtube_task_init": {
                return this.mGigsBackend.getYtVideo(bundle);
            }
            case "youtube_task_verify": {
                return this.mGigsBackend.verifyWatchedYtVideo(bundle);
            }
            case "youtube_task_get_police": {
                return this.mGigsBackend.getPoliceVideo();
            }
            case "youtube_task_report": {
                return this.mGigsBackend.reportYoutube(bundle);
            }
            case "task_request_notice": {
                HashMap<String, String> hashMap;
                String string3 = bundle.getString(QUERY_PARAMS);
                if (string3 != null && (hashMap = Utils.queryToHashMap(string3)).containsKey("app_key") && !hashMap.get("app_key").isEmpty() && hashMap.containsKey("sub_pubid") && !hashMap.get("sub_pubid").isEmpty()) {
                    return this.mNoticeApi.request(hashMap);
                }
                return new Result(Error.EMPTY);
            }
        }
        return null;
    }

    @Override
    public void onBackgroundTaskCompleted(String string2, Result result) {
        switch (string2) {
            case "task_request_notice": {
                if (result != null && result.isSuccess()) {
                    this.mNoticeResponse = (NoticeResponse)result.getResult();
                    this.mIsPolice = this.mNoticeResponse != null && this.mNoticeResponse.is_police;
                    this.mYouTubePlayerView.initialize(this, true);
                    if (this.mIsPolice) {
                        this.mWorker.executeTask(TASK_GET_POLICE, null, this);
                        return;
                    }
                    if (this.mNoticeResponse != null && this.mNoticeResponse.credential.success) {
                        this.mWorker.executeTask(TASK_GET_YT, null, this);
                        return;
                    }
                }
                this.videoNotAvailable();
                break;
            }
            case "youtube_task_init": {
                if (!result.isSuccess()) break;
                this.mVideoGigsResponse = (EmbedGigsResponse)result.getResult();
                this.mCustomPlayerUIController.initializeYtVideoInfo(this.mVideoGigsResponse);
                return;
            }
            case "youtube_task_verify": 
            case "youtube_task_report": {
                if (!result.isSuccess()) break;
                this.mVideoGigsResponse = (EmbedGigsResponse)result.getResult();
                this.mCustomPlayerUIController.verifiedYtVideo(this.mVideoGigsResponse);
                Intent intent = new Intent("gigs_force_refresh_receiver");
                LocalBroadcastManager.getInstance((Context)this).sendBroadcast(intent);
                return;
            }
            case "youtube_task_get_police": {
                if (!result.isSuccess()) break;
                EmbedGigsResponse[] embedGigsResponseArray = (EmbedGigsResponse[])result.getResult();
                if (embedGigsResponseArray.length > 0) {
                    this.mPoliceVideoResponse = new ArrayList<EmbedGigsResponse>(Arrays.asList(embedGigsResponseArray));
                    this.mCustomPlayerUIController.initializeYtVideoInfo(this.mPoliceVideoResponse.get(this.mPoliceVideoResponse.size() - 1));
                    this.mPoliceVideoResponse.remove(this.mPoliceVideoResponse.size() - 1);
                }
                return;
            }
        }
        this.videoNotAvailable();
    }

    @Override
    public void videoReachEndpoint(String string2, int n) {
        if (!this.mIsPolice) {
            Bundle bundle = new Bundle();
            bundle.putString("tid", string2);
            bundle.putInt("ts", n);
            this.mWorker.executeTask(TASK_VERIFY_YT, bundle, this);
        } else if (this.mPoliceVideoResponse.size() > 0) {
            this.mCustomPlayerUIController.verifiedYtVideo(this.mPoliceVideoResponse.get(this.mPoliceVideoResponse.size() - 1));
            this.mPoliceVideoResponse.remove(this.mPoliceVideoResponse.size() - 1);
        } else {
            this.videoNotAvailable();
        }
    }

    @Override
    public void videoNotAvailable() {
        if (!(this.isFinishing() || this.mNoVideoDialog != null && (this.mNoVideoDialog.isShowing() || this.isFinishing()))) {
            this.mNoVideoDialog = new AlertDialog.Builder((Context)new ContextThemeWrapper((Context)this, R.style.AlertDialog)).setCancelable(false).setMessage(R.string.no_video_retry).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int n) {
                    EmbedVideoActivity.this.finish();
                }
            }).show();
        }
    }

    @Override
    public void forceStopVideo() {
        if (!this.isFinishing()) {
            this.finish();
        }
    }

    @Override
    public void youtubePlayableError(String string2, String string3) {
        Bundle bundle = new Bundle();
        bundle.putString("tid", string2);
        bundle.putString("sid", string3);
        this.mWorker.executeTask(TASK_REPORT_YOUTUBE, bundle, this);
    }
}

