/*
 * Decompiled with CFR 0.152.
 */
package com.appyvet.materialrangebar;

import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Shader;
import com.appyvet.materialrangebar.PinView;
import java.util.ArrayList;

public class ConnectingLine {
    private final int[] colors;
    private final float[] positions;
    private final Paint paint = new Paint();
    private final float mY;

    public ConnectingLine(float y, float connectingLineWeight, ArrayList<Integer> connectingLineColors) {
        if (connectingLineColors.size() == 1) {
            connectingLineColors.add(connectingLineColors.get(0));
        }
        this.colors = new int[connectingLineColors.size()];
        this.positions = new float[connectingLineColors.size()];
        for (int index = 0; index < connectingLineColors.size(); ++index) {
            this.colors[index] = connectingLineColors.get(index);
            this.positions[index] = (float)index / (float)(connectingLineColors.size() - 1);
        }
        this.paint.setStrokeWidth(connectingLineWeight);
        this.paint.setStrokeCap(Paint.Cap.ROUND);
        this.paint.setAntiAlias(true);
        this.mY = y;
    }

    private LinearGradient getLinearGradient(float startX, float endX, float height) {
        return new LinearGradient(startX, height, endX, height, this.colors, this.positions, Shader.TileMode.REPEAT);
    }

    public void draw(Canvas canvas, PinView leftThumb, PinView rightThumb) {
        this.paint.setShader((Shader)this.getLinearGradient(0.0f, canvas.getWidth(), this.mY));
        canvas.drawLine(leftThumb.getX(), this.mY, rightThumb.getX(), this.mY, this.paint);
    }

    public void draw(Canvas canvas, float leftMargin, PinView rightThumb) {
        this.paint.setShader((Shader)this.getLinearGradient(0.0f, canvas.getWidth(), this.mY));
        canvas.drawLine(leftMargin, this.mY, rightThumb.getX(), this.mY, this.paint);
    }
}

