/*
 * Decompiled with CFR 0.152.
 */
package com.appyvet.materialrangebar;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import androidx.annotation.Nullable;
import com.appyvet.materialrangebar.PinView;
import java.util.ArrayList;
import java.util.List;

public class Bar {
    private final Resources mRes;
    private final Paint mBarPaint;
    private final Paint mTickPaint;
    private Paint mLabelPaint;
    private final float mLeftX;
    private final float mRightX;
    private final float mY;
    private int mNumSegments;
    private float mTickDistance;
    private final float mTickHeight;
    private int mTickLabelColor;
    private int mTickLabelSelectedColor;
    private CharSequence[] mTickTopLabels;
    private CharSequence[] mTickBottomLabels;
    private String mTickDefaultLabel;
    private float mTickLabelSize;
    private int mTickDefaultColor;
    private List<Integer> mTickColors = new ArrayList<Integer>();

    public Bar(Context ctx, float x, float y, float length, int tickCount, float tickHeight, float barWeight, int barColor, boolean isBarRounded) {
        this.mRes = ctx.getResources();
        this.mLeftX = x;
        this.mRightX = x + length;
        this.mY = y;
        this.mNumSegments = tickCount - 1;
        this.mTickDistance = length / (float)this.mNumSegments;
        this.mTickHeight = tickHeight;
        this.mBarPaint = new Paint();
        this.mBarPaint.setColor(barColor);
        this.mBarPaint.setStrokeWidth(barWeight);
        this.mBarPaint.setAntiAlias(true);
        if (isBarRounded) {
            this.mBarPaint.setStrokeCap(Paint.Cap.ROUND);
        }
        this.mTickPaint = new Paint();
        this.mTickPaint.setStrokeWidth(barWeight);
        this.mTickPaint.setAntiAlias(true);
    }

    public Bar(Context ctx, float x, float y, float length, int tickCount, float tickHeight, int tickDefaultColor, float barWeight, int barColor, boolean isBarRounded) {
        this(ctx, x, y, length, tickCount, tickHeight, barWeight, barColor, isBarRounded);
        this.mTickDefaultColor = tickDefaultColor;
        this.mTickPaint.setColor(tickDefaultColor);
    }

    public Bar(Context ctx, float x, float y, float length, int tickCount, float tickHeight, float barWeight, int barColor, boolean isBarRounded, int tickLabelColor, int tickLabelSelectedColor, CharSequence[] tickTopLabels, CharSequence[] tickBottomLabels, String tickDefaultLabel, float tickLabelSize) {
        this(ctx, x, y, length, tickCount, tickHeight, barWeight, barColor, isBarRounded);
        if (tickTopLabels != null || tickBottomLabels != null) {
            this.mLabelPaint = new Paint();
            this.mLabelPaint.setColor(tickLabelColor);
            this.mLabelPaint.setAntiAlias(true);
            this.mTickLabelColor = tickLabelColor;
            this.mTickLabelSelectedColor = tickLabelSelectedColor;
            this.mTickTopLabels = tickTopLabels;
            this.mTickBottomLabels = tickBottomLabels;
            this.mTickDefaultLabel = tickDefaultLabel;
            this.mTickLabelSize = tickLabelSize;
        }
    }

    public Bar(Context ctx, float x, float y, float length, int tickCount, float tickHeight, int tickDefaultColor, float barWeight, int barColor, boolean isBarRounded, int tickLabelColor, int tickLabelSelectedColor, CharSequence[] tickTopLabels, CharSequence[] tickBottomLabels, String tickDefaultLabel, float tickLabelSize) {
        this(ctx, x, y, length, tickCount, tickHeight, barWeight, barColor, isBarRounded, tickLabelColor, tickLabelSelectedColor, tickTopLabels, tickBottomLabels, tickDefaultLabel, tickLabelSize);
        this.mTickDefaultColor = tickDefaultColor;
        this.mTickPaint.setColor(tickDefaultColor);
    }

    public Bar(Context ctx, float x, float y, float length, int tickCount, float tickHeight, int tickDefaultColor, List<Integer> tickColors, float barWeight, int barColor, boolean isBarRounded, int tickLabelColor, int tickLabelSelectedColor, CharSequence[] tickTopLabels, CharSequence[] tickBottomLabels, String tickDefaultLabel, float tickLabelSize) {
        this(ctx, x, y, length, tickCount, tickHeight, barWeight, barColor, isBarRounded, tickLabelColor, tickLabelSelectedColor, tickTopLabels, tickBottomLabels, tickDefaultLabel, tickLabelSize);
        this.mTickDefaultColor = tickDefaultColor;
        this.mTickColors = tickColors;
    }

    public void draw(Canvas canvas) {
        canvas.drawLine(this.mLeftX, this.mY, this.mRightX, this.mY, this.mBarPaint);
    }

    public float getLeftX() {
        return this.mLeftX;
    }

    public float getRightX() {
        return this.mRightX;
    }

    public float getNearestTickCoordinate(PinView thumb) {
        int nearestTickIndex = this.getNearestTickIndex(thumb);
        return this.mLeftX + (float)nearestTickIndex * this.mTickDistance;
    }

    public int getNearestTickIndex(PinView thumb) {
        int tickIndex = (int)((thumb.getX() - this.mLeftX + this.mTickDistance / 2.0f) / this.mTickDistance);
        if (tickIndex > this.mNumSegments) {
            tickIndex = this.mNumSegments;
        } else if (tickIndex < 0) {
            tickIndex = 0;
        }
        return tickIndex;
    }

    public float getTickX(int tickIndex) {
        return this.mLeftX + (this.mRightX - this.mLeftX) / (float)this.mNumSegments * (float)tickIndex;
    }

    public void setTickCount(int tickCount) {
        float barLength = this.mRightX - this.mLeftX;
        this.mNumSegments = tickCount - 1;
        this.mTickDistance = barLength / (float)this.mNumSegments;
    }

    private String getTickLabel(int index, CharSequence[] labels) {
        if (index >= labels.length) {
            return this.mTickDefaultLabel;
        }
        return labels[index].toString();
    }

    private String getTickTopLabel(int index) {
        return this.getTickLabel(index, this.mTickTopLabels);
    }

    private String getTickBottomLabel(int index) {
        return this.getTickLabel(index, this.mTickBottomLabels);
    }

    public void drawTicks(Canvas canvas, float pinRadius, PinView rightThumb) {
        this.drawTicks(canvas, pinRadius, rightThumb, null);
    }

    public void drawTicks(Canvas canvas, float pinRadius, PinView rightThumb, @Nullable PinView leftThumb) {
        boolean paintLabel = false;
        if (this.mLabelPaint != null) {
            paintLabel = true;
            int textSize = (int)TypedValue.applyDimension((int)2, (float)this.mTickLabelSize, (DisplayMetrics)this.mRes.getDisplayMetrics());
            this.mLabelPaint.setTextSize((float)textSize);
        }
        for (int i = 0; i < this.mNumSegments; ++i) {
            float x = (float)i * this.mTickDistance + this.mLeftX;
            canvas.drawCircle(x, this.mY, this.mTickHeight, this.getTick(i));
            if (!paintLabel) continue;
            if (this.mTickTopLabels != null) {
                this.drawTickLabel(canvas, this.getTickTopLabel(i), x, pinRadius, i == 0, false, true, rightThumb, leftThumb);
            }
            if (this.mTickBottomLabels == null) continue;
            this.drawTickLabel(canvas, this.getTickBottomLabel(i), x, pinRadius, i == 0, false, false, rightThumb, leftThumb);
        }
        canvas.drawCircle(this.mRightX, this.mY, this.mTickHeight, this.getTick(this.mNumSegments));
        if (paintLabel) {
            if (this.mTickTopLabels != null) {
                this.drawTickLabel(canvas, this.getTickTopLabel(this.mNumSegments), this.mRightX, pinRadius, false, true, true, rightThumb, leftThumb);
            }
            if (this.mTickBottomLabels != null) {
                this.drawTickLabel(canvas, this.getTickBottomLabel(this.mNumSegments), this.mRightX, pinRadius, false, true, false, rightThumb, leftThumb);
            }
        }
    }

    private void drawTickLabel(Canvas canvas, String label, float x, float pinRadius, boolean first, boolean last, boolean isTop, PinView rightThumb, @Nullable PinView leftThumb) {
        boolean isSelected;
        Rect labelBounds = new Rect();
        this.mLabelPaint.getTextBounds(label, 0, label.length(), labelBounds);
        float xPos = x - (float)(labelBounds.width() / 2);
        if (first) {
            xPos += this.mTickHeight;
        } else if (last) {
            xPos -= this.mTickHeight;
        }
        boolean bl = isSelected = rightThumb.getX() == x;
        if (!isSelected && leftThumb != null) {
            boolean bl2 = isSelected = leftThumb.getX() == x;
        }
        if (isSelected) {
            this.mLabelPaint.setColor(this.mTickLabelSelectedColor);
        } else {
            this.mLabelPaint.setColor(this.mTickLabelColor);
        }
        float yPos = isTop ? this.mY - (float)labelBounds.height() - pinRadius : this.mY + (float)labelBounds.height() + pinRadius;
        canvas.drawText(label, xPos, yPos, this.mLabelPaint);
    }

    private Paint getTick(int index) {
        if (this.mTickColors != null && index < this.mTickColors.size()) {
            this.mTickPaint.setColor(this.mTickColors.get(index).intValue());
        } else {
            this.mTickPaint.setColor(this.mTickDefaultColor);
        }
        return this.mTickPaint;
    }
}

