/*
 * Decompiled with CFR 0.152.
 */
package com.apptakk.http_request;

import android.app.Activity;
import android.os.AsyncTask;
import com.apptakk.http_request.HttpRequest;
import com.apptakk.http_request.HttpResponse;
import java.lang.ref.WeakReference;

public class HttpRequestTask
extends AsyncTask<Void, Void, HttpResponse> {
    private final HttpRequest httpRequest;
    private final HttpRequest.Handler handler;
    private final WeakReference<Activity> activityRef;
    private final boolean activityRefSet;

    public HttpRequestTask(HttpRequest httpRequest, HttpRequest.Handler handler) {
        this(httpRequest, handler, null);
    }

    public HttpRequestTask(HttpRequest httpRequest, HttpRequest.Handler handler, Activity activity) {
        this.httpRequest = httpRequest;
        this.handler = handler;
        this.activityRef = new WeakReference<Activity>(activity);
        this.activityRefSet = activity != null;
    }

    protected HttpResponse doInBackground(Void ... params) {
        return this.httpRequest.request();
    }

    protected void onPostExecute(HttpResponse response) {
        this.handleResponse(response);
    }

    protected void onCancelled() {
        this.handleResponse(new HttpResponse());
    }

    private void handleResponse(HttpResponse response) {
        if (this.handler == null) {
            return;
        }
        if (!this.activityRefSet) {
            this.handler.response(response);
        } else if (this.activityRef.get() != null && !((Activity)this.activityRef.get()).isFinishing()) {
            this.handler.response(response);
        }
    }
}

