/*
 * Decompiled with CFR 0.152.
 */
package com.apptakk.http_request;

import com.apptakk.http_request.HttpResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class HttpRequest {
    public static final String OPTIONS = "OPTIONS";
    public static final String GET = "GET";
    public static final String HEAD = "HEAD";
    public static final String POST = "POST";
    public static final String PUT = "PUT";
    public static final String DELETE = "DELETE";
    public static final String TRACE = "TRACE";
    private final String url;
    private final String method;
    private final String json;
    private final String authorization;

    public HttpRequest(String url, String method) {
        this(url, method, null, null);
    }

    public HttpRequest(String url, String method, String json) {
        this(url, method, json, null);
    }

    public HttpRequest(String url, String method, String json, String authorization) {
        this.url = url;
        this.method = method;
        this.json = json;
        this.authorization = authorization;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse request() {
        HttpURLConnection con;
        HttpResponse response = new HttpResponse();
        try {
            con = (HttpURLConnection)new URL(this.url).openConnection();
        }
        catch (IOException e) {
            e.printStackTrace();
            return response;
        }
        try {
            if (this.method != null) {
                con.setRequestMethod(this.method);
            }
            if (this.authorization != null) {
                con.setRequestProperty("Authorization", this.authorization);
            }
            if (this.json != null) {
                con.setDoOutput(true);
                con.setChunkedStreamingMode(0);
                byte[] bytes = this.json.getBytes("UTF-8");
                con.setRequestProperty("Content-Type", "application/json; charset=utf-8");
                con.setRequestProperty("Accept", "application/json");
                con.setRequestProperty("Content-Length", "" + bytes.length);
                this.write(con.getOutputStream(), bytes);
            }
            response.code = con.getResponseCode();
            response.body = this.read(con.getInputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            con.disconnect();
        }
        return response;
    }

    private void write(OutputStream os, byte[] body) throws IOException {
        os.write(body);
        os.close();
    }

    private String read(InputStream in) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        br.close();
        return sb.toString();
    }

    public static interface Handler {
        public void response(HttpResponse var1);
    }
}

