/*
 * Decompiled with CFR 0.152.
 */
package com.apptakk.http_request;

import android.os.AsyncTask;
import com.apptakk.http_request.HttpRequest;
import com.apptakk.http_request.HttpResponse;

public class HttpRequestTask
extends AsyncTask<Void, Void, HttpResponse> {
    private HttpRequest httpRequest;
    private OnProgress onProgress;
    private OnTaskCompleted callback;

    HttpRequestTask(HttpRequest httpRequest, OnProgress onProgress, OnTaskCompleted callback) {
        this.httpRequest = httpRequest;
        this.onProgress = onProgress;
        this.callback = callback;
    }

    protected void onPreExecute() {
        if (this.onProgress != null) {
            this.onProgress.showProgress(true);
        }
    }

    protected HttpResponse doInBackground(Void ... params) {
        return this.httpRequest.request();
    }

    protected void onPostExecute(HttpResponse response) {
        if (this.onProgress != null) {
            this.onProgress.showProgress(false);
        }
        if (this.callback != null) {
            this.callback.onTaskCompleted(response);
        }
    }

    protected void onCancelled() {
        if (this.onProgress != null) {
            this.onProgress.showProgress(false);
        }
        if (this.callback != null) {
            this.callback.onTaskCompleted(new HttpResponse());
        }
    }

    public static interface OnProgress {
        public void showProgress(boolean var1);
    }

    public static interface OnTaskCompleted {
        public void onTaskCompleted(HttpResponse var1);
    }
}

