/*
 * Decompiled with CFR 0.152.
 */
package com.apptakk.http_request;

import com.apptakk.http_request.HttpResponse;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;

public class HttpRequest {
    public static final String OPTIONS = "OPTIONS";
    public static final String GET = "GET";
    public static final String HEAD = "HEAD";
    public static final String POST = "POST";
    public static final String PUT = "PUT";
    public static final String DELETE = "DELETE";
    public static final String TRACE = "TRACE";
    private final String url;
    private final String method;
    private final String json;
    private final String auth;

    public HttpRequest(String url, String method, String json, String auth) {
        this.url = url;
        this.method = method;
        this.json = json;
        this.auth = auth;
    }

    public static void write(OutputStream os, String body) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
        writer.write(body);
        writer.flush();
        writer.close();
        os.close();
    }

    public static String read(InputStream in) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        br.close();
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse request() {
        HttpURLConnection con;
        HttpResponse httpResponse = new HttpResponse();
        try {
            con = (HttpURLConnection)new URL(this.url).openConnection();
        }
        catch (IOException e) {
            e.printStackTrace();
            return httpResponse;
        }
        try {
            if (this.method != null) {
                con.setRequestMethod(this.method);
            }
            if (this.auth != null) {
                con.setRequestProperty("Authorization", this.auth);
            }
            if (this.json != null) {
                con.setDoOutput(true);
                con.setChunkedStreamingMode(0);
                con.setRequestProperty("Content-Type", "application/json");
                con.setRequestProperty("Content-Length", "" + this.json.length());
                con.setRequestProperty("Accept", "application/json");
                HttpRequest.write(con.getOutputStream(), this.json);
            }
            httpResponse.code = con.getResponseCode();
            httpResponse.body = HttpRequest.read(con.getInputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            con.disconnect();
        }
        return httpResponse;
    }
}

