/*
 * Decompiled with CFR 0.152.
 */
package com.apptakk.http_request;

import com.apptakk.http_request.HttpResponse;
import com.apptakk.http_request.IO;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

public class HttpRequest {
    public static final String OPTIONS = "OPTIONS";
    public static final String GET = "GET";
    public static final String HEAD = "HEAD";
    public static final String POST = "POST";
    public static final String PUT = "PUT";
    public static final String DELETE = "DELETE";
    public static final String TRACE = "TRACE";
    private final String url;
    private final String method;
    private final String json;
    private final Map<String, String> requestProperties;

    public HttpRequest(String url, String method) {
        this(url, method, null, null);
    }

    public HttpRequest(String url, String method, String json) {
        this(url, method, json, null);
    }

    public HttpRequest(String url, String method, String json, Map<String, String> requestProperties) {
        this.url = url;
        this.method = method;
        this.json = json;
        this.requestProperties = requestProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse request() {
        HttpURLConnection con;
        HttpResponse response = new HttpResponse();
        try {
            con = (HttpURLConnection)new URL(this.url).openConnection();
        }
        catch (IOException e) {
            e.printStackTrace();
            return response;
        }
        try {
            if (this.method != null) {
                con.setRequestMethod(this.method);
            }
            if (this.requestProperties != null) {
                for (Map.Entry<String, String> entry : this.requestProperties.entrySet()) {
                    con.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            if (this.json != null) {
                con.setDoOutput(true);
                con.setChunkedStreamingMode(0);
                byte[] bytes = this.json.getBytes("UTF-8");
                con.setRequestProperty("Content-Type", "application/json; charset=utf-8");
                con.setRequestProperty("Accept", "application/json");
                con.setRequestProperty("Content-Length", "" + bytes.length);
                IO.write(con.getOutputStream(), bytes);
            }
            response.code = con.getResponseCode();
            response.body = IO.read(con.getInputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            con.disconnect();
        }
        return response;
    }

    public static interface Handler {
        public void response(HttpResponse var1);
    }
}

