/*
 * Decompiled with CFR 0.152.
 */
package com.rainy.networkhelper.future;

import android.content.Context;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.rainy.networkhelper.future.ExecutionFuture;
import com.rainy.networkhelper.request.BaseRequest;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

public class AsyncRequestFuture<T>
extends ExecutionFuture<T>
implements Response.Listener<T>,
Response.ErrorListener {
    protected BaseRequest<T> mRequest;
    private Context context;
    private Exception mException;
    private T mResult;
    private boolean mResultReceived = false;

    protected AsyncRequestFuture(Context context, BaseRequest<T> request) {
        this.context = context;
        this.mRequest = request;
    }

    public static <E> AsyncRequestFuture<E> newFuture(Context context, BaseRequest<E> request) {
        return new AsyncRequestFuture<E>(context, request);
    }

    @Override
    protected synchronized T execute(Long timeoutMs) throws Exception {
        if (this.mException != null) {
            throw new ExecutionException(this.mException);
        }
        if (this.mResultReceived) {
            return this.mResult;
        }
        this.mRequest.send(this.context);
        if (timeoutMs == null) {
            this.wait(0L);
        } else if (timeoutMs > 0L) {
            this.wait(timeoutMs);
        }
        if (this.mException != null) {
            throw new ExecutionException(this.mException);
        }
        if (!this.mResultReceived) {
            throw new TimeoutException();
        }
        return this.mResult;
    }

    public void setRequest(BaseRequest<T> mRequest) {
        this.mRequest = mRequest;
    }

    public Request<?> getRequest() {
        return this.mRequest;
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        boolean cancel = super.cancel(mayInterruptIfRunning);
        if (this.mRequest != null) {
            this.mRequest.cancel();
        }
        return cancel;
    }

    public synchronized void onResponse(T response) {
        this.mResult = response;
        this.mResultReceived = true;
        this.notifyAll();
    }

    public synchronized void onErrorResponse(VolleyError error) {
        this.mException = error;
        this.mResultReceived = true;
        this.notifyAll();
    }

    public Context getContext() {
        return this.context;
    }
}

