/*
 * Decompiled with CFR 0.152.
 */
package com.rainy.networkhelper.future;

import android.content.Context;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.rainy.networkhelper.future.ExecutionFuture;
import com.rainy.networkhelper.request.BaseRequest;
import com.rainy.networkhelper.response.ParsedResponse;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

public class ParsedAsyncRequestFuture<T>
extends ExecutionFuture<T>
implements Response.Listener<ParsedResponse<T>>,
Response.ErrorListener {
    protected BaseRequest<ParsedResponse<T>> mRequest;
    private Context context;
    private Exception mException;
    private T mResult;
    private boolean mResultReceived = false;

    protected ParsedAsyncRequestFuture(Context context, BaseRequest<ParsedResponse<T>> request) {
        this.context = context;
        this.mRequest = request;
    }

    public static <E> ParsedAsyncRequestFuture<E> newFuture(Context context, BaseRequest<ParsedResponse<E>> request) {
        return new ParsedAsyncRequestFuture(context, request);
    }

    @Override
    protected synchronized T execute(Long timeoutMs) throws Exception {
        if (this.mException != null) {
            throw new ExecutionException(this.mException);
        }
        if (this.mResultReceived) {
            return this.mResult;
        }
        this.mRequest.send(this.context);
        if (timeoutMs == null) {
            this.wait(0L);
        } else if (timeoutMs > 0L) {
            this.wait(timeoutMs);
        }
        if (this.mException != null) {
            throw new ExecutionException(this.mException);
        }
        if (!this.mResultReceived) {
            throw new TimeoutException();
        }
        return this.mResult;
    }

    public void setRequest(BaseRequest<ParsedResponse<T>> mRequest) {
        this.mRequest = mRequest;
    }

    public Request<ParsedResponse<T>> getRequest() {
        return this.mRequest;
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        boolean cancel = super.cancel(mayInterruptIfRunning);
        if (this.mRequest != null) {
            this.mRequest.cancel();
        }
        return cancel;
    }

    public synchronized void onResponse(ParsedResponse<T> response) {
        if (response != null) {
            this.mResult = response.getParsedResponse();
        }
        this.mResultReceived = true;
        this.notifyAll();
    }

    public synchronized void onErrorResponse(VolleyError error) {
        this.mException = error;
        this.mResultReceived = true;
        this.notifyAll();
    }
}

