/*
 * Decompiled with CFR 0.152.
 */
package com.rainy.networkhelper.request;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.android.volley.AuthFailureError;
import com.android.volley.NetworkResponse;
import com.android.volley.NoConnectionError;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.Volley;
import com.rainy.networkhelper.annotation.ExpectedStatusCode;
import com.rainy.networkhelper.annotation.QueryConstantParam;
import com.rainy.networkhelper.annotation.QueryConstantParams;
import com.rainy.networkhelper.annotation.RequestMethod;
import com.rainy.networkhelper.util.ReflectionUtil;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseRequest<T>
extends Request<T> {
    public final String HEADER_CONTENT_TYPE = "Content-Type";
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, String> queryParams = new HashMap<String, String>();
    private Map<String, String> pathParams = new HashMap<String, String>();
    private Response.Listener<T> listener;
    private static RequestQueue queue;
    private int connectionType = -1;
    private int[] expectedStatusCode = new int[]{0};
    private Integer method = null;
    private String url;

    public BaseRequest(Response.Listener<T> listener, Response.ErrorListener errorListener) throws IllegalArgumentException {
        super(0, null, errorListener);
        ExpectedStatusCode expectedStatusCode;
        QueryConstantParams queryConstantParams;
        this.listener = listener;
        RequestMethod requestMethod = (RequestMethod)ReflectionUtil.getClassAnnotation(((Object)((Object)this)).getClass(), RequestMethod.class);
        if (requestMethod == null) {
            throw new IllegalArgumentException("This class must be annotated with RequestMethod annotation.");
        }
        if (requestMethod.url() == null || requestMethod.url().length() == 0) {
            throw new IllegalArgumentException("The RequestMethod annotation's url must be specified.");
        }
        this.method = requestMethod.method();
        this.url = requestMethod.url();
        QueryConstantParam queryConstantParam = (QueryConstantParam)ReflectionUtil.getClassAnnotation(((Object)((Object)this)).getClass(), QueryConstantParam.class);
        if (queryConstantParam != null) {
            this.queryParams.put(queryConstantParam.name(), queryConstantParam.value());
        }
        if ((queryConstantParams = (QueryConstantParams)ReflectionUtil.getClassAnnotation(((Object)((Object)this)).getClass(), QueryConstantParams.class)) != null) {
            for (QueryConstantParam queryConstantParam1 : queryConstantParams.value()) {
                this.queryParams.put(queryConstantParam1.name(), queryConstantParam1.value());
            }
        }
        if ((expectedStatusCode = (ExpectedStatusCode)ReflectionUtil.getClassAnnotation(((Object)((Object)this)).getClass(), ExpectedStatusCode.class)) != null) {
            for (int code : this.expectedStatusCode = expectedStatusCode.values()) {
                if (code >= 200 && code <= 299) continue;
                throw new IllegalArgumentException("expected status codes must be in 200-299 range");
            }
        }
    }

    public BaseRequest(int httpMethod, String url, Response.Listener<T> listener, Response.ErrorListener errorListener) {
        super(httpMethod, url, errorListener);
        this.listener = listener;
    }

    public BaseRequest(int httpMethod, String url, Map<String, String> headers, Response.Listener<T> listener, Response.ErrorListener errorListener) {
        super(httpMethod, url, errorListener);
        this.listener = listener;
        this.headers = headers;
    }

    protected Map<String, String> getParams() throws AuthFailureError {
        return null;
    }

    public void send(Context context) {
        if (queue == null) {
            queue = Volley.newRequestQueue((Context)context.getApplicationContext());
        }
        this.send(context, queue);
    }

    public void send(Context context, RequestQueue requestQueue) {
        if (!BaseRequest.isConnectionAvailable(context, this.connectionType)) {
            this.deliverError((VolleyError)new NoConnectionError());
            return;
        }
        requestQueue.add((Request)this);
    }

    public Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    public Map<String, String> getPathParams() {
        return this.pathParams;
    }

    public void setPathParam(String pathParamName, String value) {
        this.pathParams.put(pathParamName, value);
    }

    public void addQueryParam(String name, String value) {
        this.queryParams.put(name, value);
    }

    public Map<String, String> getHeaders() throws AuthFailureError {
        this.headers.putAll(ReflectionUtil.getMethodsAndFieldValuesAnnotatedWithHeaderParam((Object)this));
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void addHeaderParam(String name, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(name, value);
    }

    public static boolean isConnectionAvailable(Context context, int type) {
        if (type == -1) {
            return true;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        if (connectivityManager != null) {
            networkInfo = connectivityManager.getNetworkInfo(type);
        }
        return networkInfo != null && networkInfo.isConnected();
    }

    public int getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(int connectionType) {
        this.connectionType = connectionType;
    }

    public int getMethod() {
        if (this.method != null) {
            return this.method;
        }
        return super.getMethod();
    }

    public String getUrl() {
        String _url;
        String string = _url = this.url != null ? this.url : super.getUrl();
        if (_url != null) {
            this.pathParams.putAll(ReflectionUtil.getMethodsAndFieldValuesAnnotatedWithPathParam((Object)this));
            if (this.getPathParams() != null) {
                for (Map.Entry<String, String> entry : this.getPathParams().entrySet()) {
                    _url = _url.replaceAll("\\{" + entry.getKey() + "\\}", entry.getValue());
                }
            }
            this.queryParams.putAll(ReflectionUtil.getMethodsAndFieldValuesAnnotatedWithQueryParam((Object)this));
            if (this.getQueryParams() != null) {
                for (Map.Entry<String, String> entry : this.getQueryParams().entrySet()) {
                    String c = _url.contains("?") ? "&" : "?";
                    _url = _url + c + entry.getKey() + "=" + entry.getValue();
                }
            }
        }
        return _url;
    }

    protected Boolean isResponseValid(NetworkResponse response) {
        if (response != null && this.expectedStatusCode.length > 0 && this.expectedStatusCode[0] != 0) {
            for (int code : this.expectedStatusCode) {
                if (code != response.statusCode) continue;
                return true;
            }
            return false;
        }
        return null;
    }

    protected void deliverResponse(T basicResponseDto) {
        if (this.listener != null) {
            this.listener.onResponse(basicResponseDto);
        }
    }

    public static RequestQueue getQueue() {
        return queue;
    }
}

