/*
 * Decompiled with CFR 0.152.
 */
package com.rainy.networkhelper.request;

import com.android.volley.AuthFailureError;
import com.android.volley.Cache;
import com.android.volley.NetworkResponse;
import com.android.volley.ParseError;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.HttpHeaderParser;
import com.rainy.networkhelper.mapper.BodyMapper;
import com.rainy.networkhelper.mapper.GsonBodyMapper;
import com.rainy.networkhelper.request.BaseRequest;
import com.rainy.networkhelper.response.ParsedResponse;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.util.Map;

public class ParserRequest<T>
extends BaseRequest<ParsedResponse<T>> {
    private Class<T> clazz = null;
    private Type type = null;
    private Object requestDto = null;
    private BodyMapper bodyEncoder = new GsonBodyMapper();
    private BodyMapper responseDecoder = new GsonBodyMapper();

    public ParserRequest(Class<T> clazz, Response.Listener<ParsedResponse<T>> listener, Response.ErrorListener errorListener) throws IllegalArgumentException {
        super(listener, errorListener);
        this.clazz = clazz;
    }

    public ParserRequest(Type type, Response.Listener<ParsedResponse<T>> listener, Response.ErrorListener errorListener) throws IllegalArgumentException {
        super(listener, errorListener);
        this.type = type;
    }

    public ParserRequest(int httpMethod, String url, Class<T> clazz, Response.Listener<ParsedResponse<T>> listener, Response.ErrorListener errorListener) {
        super(httpMethod, url, listener, errorListener);
        this.clazz = clazz;
    }

    public ParserRequest(int httpMethod, String url, Type type, Response.Listener<ParsedResponse<T>> listener, Response.ErrorListener errorListener) {
        super(httpMethod, url, listener, errorListener);
        this.type = type;
    }

    public ParserRequest(int httpMethod, String url, Map<String, String> headers, Class<T> clazz, Response.Listener<ParsedResponse<T>> listener, Response.ErrorListener errorListener) {
        super(httpMethod, url, headers, listener, errorListener);
        this.clazz = clazz;
    }

    public Object getRequestDto() {
        return this.requestDto;
    }

    public void setRequestDto(Object requestDto) {
        this.requestDto = requestDto;
    }

    public String getBodyContentType() {
        try {
            return this.getHeaders() != null && this.getHeaders().containsKey("Content-Type") ? this.getHeaders().get("Content-Type") : this.bodyEncoder.getContentType();
        }
        catch (AuthFailureError authFailureError) {
            authFailureError.printStackTrace();
            return super.getBodyContentType();
        }
    }

    public BodyMapper getBodyEncoder() {
        return this.bodyEncoder;
    }

    public BaseRequest setBodyEncoder(BodyMapper bodyEncoder) {
        this.bodyEncoder = bodyEncoder;
        return this;
    }

    public BodyMapper getResponseDecoder() {
        return this.responseDecoder;
    }

    public BaseRequest setResponseDecoder(BodyMapper responseDecoder) {
        this.responseDecoder = responseDecoder;
        return this;
    }

    public byte[] getBody() throws AuthFailureError {
        if (this.requestDto != null) {
            try {
                return this.bodyEncoder.encodeParams(this.requestDto, this.getParamsEncoding());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected Response<ParsedResponse<T>> parseNetworkResponse(NetworkResponse response) {
        try {
            if (this.clazz == null && this.type == null || this.clazz == NetworkResponse.class) {
                ParsedResponse<Object> parsedResponse = new ParsedResponse<Object>(response, null);
                return Response.success(parsedResponse, (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)response));
            }
            if (this.clazz != null) {
                T parsed = this.getResponseDecoder().decodeParams(response.data, this.clazz, HttpHeaderParser.parseCharset((Map)response.headers));
                ParsedResponse<T> parsedResponse = new ParsedResponse<T>(response, parsed);
                return Response.success(parsedResponse, (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)response));
            }
            Object parsed = this.getResponseDecoder().decodeParams(response.data, this.type, HttpHeaderParser.parseCharset((Map)response.headers));
            ParsedResponse parsedResponse = new ParsedResponse(response, parsed);
            return Response.success(parsedResponse, (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)response));
        }
        catch (UnsupportedEncodingException e) {
            return Response.error((VolleyError)new ParseError((Throwable)e));
        }
        catch (Exception e) {
            return Response.error((VolleyError)new ParseError((Throwable)e));
        }
    }
}

