package com.appspiriment.baseclasses

import android.app.Activity
import android.content.Context
import android.content.Intent
import android.os.Bundle

fun Context.startActivity(activityClass: Class<out Activity>, extras: Bundle) {
    startActivity(Intent(this.applicationContext, activityClass).apply {
        flags = Intent.FLAG_ACTIVITY_NEW_TASK
        putExtras(extras)
    })
}