/*
 * Decompiled with CFR 0.152.
 */
package com.appsng.multiplecontactselection;

import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.os.Bundle;
import android.os.Handler;
import android.provider.ContactsContract;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.util.SparseBooleanArray;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.appsng.multiplecontactselection.Contact;
import com.appsng.multiplecontactselection.R;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class Multiple
extends AppCompatActivity {
    static ListView listView;
    private ArrayList<Contact> list = new ArrayList();
    ArrayList<String> selected_phones = new ArrayList();
    static final int DONE = 1;
    Toolbar toolbar;
    CheckBox checkBox;
    Context context;
    int theMainCounter = 0;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_contacts);
        this.toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        listView = (ListView)this.findViewById(R.id.contact_list);
        this.checkBox = (CheckBox)this.findViewById(R.id.checkBox);
        this.context = this.getApplicationContext();
        this.FetchContactonBackground();
        this.setCheckBox();
    }

    private void setCheckBox() {
        this.checkBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                Multiple.this.toggleCheckBox(isChecked);
            }
        });
    }

    private void toggleCheckBox(boolean isChecked) {
        for (int i = 0; i < listView.getCount(); ++i) {
            listView.setItemChecked(i, isChecked);
        }
    }

    protected void onStart() {
        super.onStart();
        if (this.toolbar != null) {
            this.setSupportActionBar(this.toolbar);
            this.getSupportActionBar().setTitle((CharSequence)"Select Contact");
        }
    }

    private void FetchContactonBackground() {
        final Handler handlert = new Handler();
        Thread loginUserThread = new Thread(new Runnable(){

            @Override
            public void run() {
                Multiple.this.FetchContact();
                handlert.post(new Runnable(){

                    @Override
                    public void run() {
                        ArrayAdapter arrayAdapter = new ArrayAdapter(Multiple.this.context, R.layout.custom_checked_text, (List)Multiple.this.list);
                        listView.setAdapter((ListAdapter)arrayAdapter);
                        listView.setChoiceMode(2);
                        Multiple.this.setClickEvents();
                    }
                });
            }
        });
        loginUserThread.start();
    }

    protected void onResume() {
        super.onResume();
    }

    private void FetchContact() {
        String sort = "display_name ASC";
        Cursor phones = this.context.getContentResolver().query(ContactsContract.CommonDataKinds.Phone.CONTENT_URI, null, null, null, sort);
        while (phones.moveToNext()) {
            String name = phones.getString(phones.getColumnIndex("display_name"));
            String phoneNumber = phones.getString(phones.getColumnIndex("data1"));
            String contactid = phones.getString(phones.getColumnIndex("contact_id"));
            Contact objContact = new Contact();
            objContact.setName(Multiple.capitallizeString(name));
            objContact.setPhoneNo(phoneNumber);
            objContact.setContactId(contactid);
            objContact.setSelected(false);
            this.list.add(objContact);
        }
        phones.close();
    }

    public static String capitallizeString(String text) {
        return String.valueOf(text.charAt(0)).toUpperCase(Locale.getDefault()) + text.subSequence(1, text.length());
    }

    private void setClickEvents() {
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                Multiple.this.countSelected();
            }
        });
    }

    private void countSelected() {
        int counter = listView.getCheckedItemCount();
        this.getSupportActionBar().setTitle((CharSequence)(counter + " selected"));
    }

    private void showSelected() {
        int len = listView.getCount();
        SparseBooleanArray checked = listView.getCheckedItemPositions();
        for (int i = 0; i < len; ++i) {
            if (!checked.get(i)) continue;
            String g = this.list.get(i).getPhoneNo();
            g = g.replace("-", "");
            g = g.replace(" ", "");
            g = g.replace("(", "");
            g = g.replace(")", "");
            this.addToListOfNumbers(g);
        }
    }

    private void addToListOfNumbers(String number) {
        if (!this.selected_phones.contains(number)) {
            this.selected_phones.add(number);
        }
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        menu.add(0, 1, 0, (CharSequence)"DONE").setShowAsAction(2);
        return super.onCreateOptionsMenu(menu);
    }

    public void onDestroy() {
        super.onDestroy();
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.finish();
                return true;
            }
            case 1: {
                this.SendDataBack();
                return true;
            }
        }
        return false;
    }

    private void SendDataBack() {
        this.showSelected();
        Intent returnIntent = new Intent();
        returnIntent.putExtra("result", this.selected_phones);
        this.setResult(-1, returnIntent);
        this.finish();
    }

    private void returnEmptyData() {
        Intent returnIntent = new Intent();
        this.setResult(0, returnIntent);
        this.finish();
    }
}

