/*
 * Decompiled with CFR 0.152.
 */
package com.appsng.multiplecontactselection;

import android.app.ActionBar;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.os.Bundle;
import android.os.Handler;
import android.provider.ContactsContract;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.text.Html;
import android.util.SparseBooleanArray;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.CheckBox;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.appsng.multiplecontactselection.Contact;
import com.appsng.multiplecontactselection.ContactAdapter;
import com.appsng.multiplecontactselection.R;
import java.util.ArrayList;
import java.util.Locale;

public class Multiple
extends AppCompatActivity {
    static ListView listView;
    private ArrayList<Contact> list = new ArrayList();
    ArrayList<String> selected_phones = new ArrayList();
    static final int DONE = 1;
    ActionBar acBar;
    Toolbar toolbar;
    Context context;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_contacts);
        this.toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        listView = (ListView)this.findViewById(R.id.contact_list);
        this.context = this.getApplicationContext();
        this.acBar = this.getActionBar();
        if (this.toolbar != null) {
            this.setSupportActionBar(this.toolbar);
            this.getSupportActionBar().setTitle((CharSequence)"Select Contact");
        }
        this.FetchContactonBackground();
    }

    private void FetchContactonBackground() {
        final Handler handlert = new Handler();
        Thread loginUserThread = new Thread(new Runnable(){

            @Override
            public void run() {
                Multiple.this.FetchContact();
                handlert.post(new Runnable(){

                    @Override
                    public void run() {
                        ContactAdapter objAdapter = new ContactAdapter(Multiple.this.context, Multiple.this.list, true);
                        listView.setAdapter((ListAdapter)objAdapter);
                        listView.setChoiceMode(2);
                        listView.setTextFilterEnabled(true);
                        Multiple.this.setClickEvents();
                    }
                });
            }
        });
        loginUserThread.start();
    }

    protected void onResume() {
        super.onResume();
    }

    private void FetchContact() {
        String sort = "display_name ASC";
        Cursor phones = this.context.getContentResolver().query(ContactsContract.CommonDataKinds.Phone.CONTENT_URI, null, null, null, sort);
        while (phones.moveToNext()) {
            String name = phones.getString(phones.getColumnIndex("display_name"));
            String phoneNumber = phones.getString(phones.getColumnIndex("data1"));
            String contactid = phones.getString(phones.getColumnIndex("contact_id"));
            Contact objContact = new Contact();
            objContact.setName(Multiple.capitallizeString(name));
            objContact.setPhoneNo(phoneNumber);
            objContact.setContactId(contactid);
            objContact.setSelected(false);
            this.list.add(objContact);
        }
        phones.close();
    }

    public static String capitallizeString(String text) {
        return String.valueOf(text.charAt(0)).toUpperCase(Locale.getDefault()) + text.subSequence(1, text.length());
    }

    private void setClickEvents() {
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                CheckBox checkbox = (CheckBox)view.getTag(R.id.check);
                ((Contact)Multiple.this.list.get(position)).setSelected(view.isSelected());
                if (checkbox.isChecked()) {
                    checkbox.setChecked(false);
                } else {
                    checkbox.setChecked(true);
                }
                Multiple.this.showSelected();
            }
        });
    }

    private void showSelected() {
        int selected = 0;
        int len = listView.getCount();
        SparseBooleanArray checked = listView.getCheckedItemPositions();
        for (int i = 0; i < len; ++i) {
            if (!checked.get(i)) continue;
            String g = this.list.get(i).getPhoneNo();
            g = g.replace("-", "");
            g = g.replace(" ", "");
            g = g.replace("(", "");
            g = g.replace(")", "");
            this.selected_phones.add(g);
            ++selected;
        }
        this.getActionBar().setSubtitle((CharSequence)Html.fromHtml((String)("<font color='#FFFFFF'>" + selected + " selected</font>")));
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        menu2.add(0, 1, 0, (CharSequence)"DONE").setShowAsAction(2);
        return super.onCreateOptionsMenu(menu2);
    }

    public void onDestroy() {
        super.onDestroy();
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.finish();
                return true;
            }
            case 1: {
                this.SendDataBack();
                return true;
            }
        }
        return false;
    }

    private void SendDataBack() {
        Intent returnIntent = new Intent();
        returnIntent.putExtra("result", this.selected_phones);
        this.setResult(-1, returnIntent);
        this.finish();
    }

    private void returnEmptyData() {
        Intent returnIntent = new Intent();
        this.setResult(0, returnIntent);
        this.finish();
    }
}

