/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.validators;

import jakarta.validation.Constraint;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.Payload;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={ConstraintValidatorImpl.class})
@Documented
public @interface ValidStrings {
    public String message() default "{com.appslandia.common.validators.ValidStrings.message}";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public String[] value();

    public boolean ignoreCase() default false;

    public static class ConstraintValidatorImpl
    implements ConstraintValidator<ValidStrings, String> {
        private String[] validValues;
        private boolean ignoreCase;

        public void initialize(ValidStrings annotation) {
            this.validValues = annotation.value();
            this.ignoreCase = annotation.ignoreCase();
        }

        public boolean isValid(String value, ConstraintValidatorContext context) {
            if (value == null) {
                return true;
            }
            for (String validValue : this.validValues) {
                if (!(this.ignoreCase ? validValue.equalsIgnoreCase(value) : validValue.equals(value))) continue;
                return true;
            }
            return false;
        }
    }

    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface List {
        public ValidStrings[] value();
    }
}

