/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.validators;

import jakarta.validation.Constraint;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.Payload;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={ConstraintValidatorImpl.class})
@Documented
public @interface ValidInts {
    public String message() default "{com.appslandia.common.validators.ValidInts.message}";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public int[] value();

    public static class ConstraintValidatorImpl
    implements ConstraintValidator<ValidInts, Number> {
        private int[] validValues;

        public void initialize(ValidInts annotation) {
            this.validValues = annotation.value();
        }

        public boolean isValid(Number value, ConstraintValidatorContext context) {
            if (value == null) {
                return true;
            }
            int valueToCheck = value.intValue();
            for (int validValue : this.validValues) {
                if (validValue != valueToCheck) continue;
                return true;
            }
            return false;
        }
    }

    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface List {
        public ValidInts[] value();
    }
}

