/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.validators;

import jakarta.validation.Constraint;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.Payload;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.regex.Pattern;

@Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={ConstraintValidatorImpl.class})
@Documented
public @interface PathComponent {
    public static final Pattern PATH_COMPONENT_PATTERN = Pattern.compile("[a-z\\d-]+");

    public String message() default "{com.appslandia.common.validators.PathComponent.message}";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static class ConstraintValidatorImpl
    implements ConstraintValidator<PathComponent, String> {
        public void initialize(PathComponent annotation) {
        }

        public boolean isValid(String value, ConstraintValidatorContext context) {
            if (value == null) {
                return true;
            }
            return PATH_COMPONENT_PATTERN.matcher(value).matches();
        }
    }

    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface List {
        public PathComponent[] value();
    }
}

