/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.validators;

import jakarta.validation.Constraint;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.Payload;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.regex.Pattern;

@Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={ConstraintValidatorImpl.class})
@Documented
public @interface Nickname {
    public static final Pattern NICKNAME_PATTERN = Pattern.compile("[a-zA-Z]{1,}[\\d]*", 2);

    public String message() default "{com.appslandia.common.validators.Nickname.message}";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public int minLen() default 3;

    public int maxLen();

    public static class ConstraintValidatorImpl
    implements ConstraintValidator<Nickname, CharSequence> {
        int minLen;
        int maxLen;

        public void initialize(Nickname annotation) {
            this.minLen = annotation.minLen();
            this.maxLen = annotation.maxLen();
        }

        public boolean isValid(CharSequence value, ConstraintValidatorContext context) {
            if (value == null) {
                return true;
            }
            if (!NICKNAME_PATTERN.matcher(value).matches()) {
                return false;
            }
            return value.length() >= this.minLen && value.length() <= this.maxLen;
        }
    }

    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface List {
        public Nickname[] value();
    }
}

