/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.validators;

import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.ObjectUtils;
import java.util.HashMap;
import java.util.Map;

public abstract class ModelValidator<T> {
    private static final Map<String, ModelValidator<?>> VALIDATORS = new HashMap();

    public abstract boolean validate(T var1);

    public static void addValidator(String key, ModelValidator<?> modelValidator) {
        AssertUtils.assertTrue(!VALIDATORS.containsKey(key), "validator already exists (key=" + key + ")");
        VALIDATORS.put(key, modelValidator);
    }

    public static <T> ModelValidator<T> getValidator(String key) throws IllegalArgumentException {
        ModelValidator<?> validator = VALIDATORS.get(key);
        if (validator == null) {
            throw new IllegalArgumentException("validator is not found (key=" + key + ")");
        }
        return (ModelValidator)ObjectUtils.cast(validator);
    }
}

