/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.validators;

import com.appslandia.common.utils.AssertUtils;
import jakarta.validation.Constraint;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.Payload;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={ConstraintValidatorImpl.class})
@Documented
public @interface BitMask {
    public String message() default "{com.appslandia.common.validators.BitMask.message}";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public int value();

    public static class ConstraintValidatorImpl
    implements ConstraintValidator<BitMask, Number> {
        private long max;

        public void initialize(BitMask annotation) {
            int size = annotation.value();
            AssertUtils.assertTrue(size >= 1 && size <= 63, "size is out of range [1-63]");
            this.max = size == 63 ? Long.MAX_VALUE : (long)((1 << size) - 1);
        }

        public boolean isValid(Number value, ConstraintValidatorContext context) {
            if (value == null) {
                return true;
            }
            long longValue = value.longValue();
            if (longValue < 0L) {
                return false;
            }
            return this.max <= 0L || longValue <= this.max;
        }
    }

    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface List {
        public BitMask[] value();
    }
}

