/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.base.StringWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;

public class XmlEscaper {
    private static final int HIGHEST_SPECIAL = 62;
    private static char[][] ESCAPE_XML_CONTENT = new char[63][];
    private static char[][] ESCAPE_XML;

    public static void escapeXmlContent(Writer out, String s) throws IOException {
        XmlEscaper.writeEscapeXml(out, s, ESCAPE_XML_CONTENT);
    }

    public static void escapeXml(Writer out, String s) throws IOException {
        XmlEscaper.writeEscapeXml(out, s, ESCAPE_XML);
    }

    public static String escapeXmlContent(String s) {
        String string;
        if (s == null) {
            return null;
        }
        StringWriter out = new StringWriter((int)((float)s.length() * 1.25f));
        try {
            XmlEscaper.writeEscapeXml(out, s, ESCAPE_XML_CONTENT);
            string = out.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        out.close();
        return string;
    }

    public static String escapeXml(String s) {
        String string;
        if (s == null) {
            return null;
        }
        StringWriter out = new StringWriter((int)((float)s.length() * 1.25f));
        try {
            XmlEscaper.writeEscapeXml(out, s, ESCAPE_XML);
            string = out.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        out.close();
        return string;
    }

    static void writeEscapeXml(Writer out, String s, char[][] escapeXml) throws IOException {
        int start = 0;
        char[] srcChars = s.toCharArray();
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char[] escaped;
            char c = srcChars[i];
            if (c > '>' || (escaped = escapeXml[c]) == null) continue;
            if (start < i) {
                out.write(srcChars, start, i - start);
            }
            out.write(escaped);
            start = i + 1;
        }
        if (start < length) {
            out.write(srcChars, start, length - start);
        }
    }

    static {
        XmlEscaper.ESCAPE_XML_CONTENT[38] = "&amp;".toCharArray();
        XmlEscaper.ESCAPE_XML_CONTENT[60] = "&lt;".toCharArray();
        XmlEscaper.ESCAPE_XML_CONTENT[62] = "&gt;".toCharArray();
        ESCAPE_XML = new char[63][];
        XmlEscaper.ESCAPE_XML[38] = "&amp;".toCharArray();
        XmlEscaper.ESCAPE_XML[60] = "&lt;".toCharArray();
        XmlEscaper.ESCAPE_XML[62] = "&gt;".toCharArray();
        XmlEscaper.ESCAPE_XML[34] = "&#34;".toCharArray();
        XmlEscaper.ESCAPE_XML[39] = "&#39;".toCharArray();
    }
}

