/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.base.TextBuilder;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.TypeVariable;
import java.sql.PreparedStatement;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;

public class WrapperClassGenerator {
    private static final Skipped DEFAULT_SKIPPED = new Skipped(){

        @Override
        public boolean apply(Method method) {
            if (Modifier.isStatic(method.getModifiers())) {
                return true;
            }
            if (Modifier.isPrivate(method.getModifiers())) {
                return true;
            }
            return Modifier.isFinal(method.getModifiers());
        }
    };

    public static void main(String[] args) {
        MethodComparator comparator = new MethodComparator(new String[]{"execute", "set"}, null);
        System.out.println(WrapperClassGenerator.generateWrapper(PreparedStatement.class, "this.stat", comparator));
    }

    public static String generateWrapper(Class<?> clazz, String wrappedField, MethodComparator comparator) {
        return WrapperClassGenerator.generateWrapper(clazz, wrappedField, comparator, null, DEFAULT_SKIPPED);
    }

    public static String generateWrapper(Class<?> clazz, String wrappedField, MethodComparator comparator, Unsupported unsupported) {
        return WrapperClassGenerator.generateWrapper(clazz, wrappedField, comparator, unsupported, DEFAULT_SKIPPED);
    }

    public static String generateWrapper(Class<?> clazz, String wrappedField, MethodComparator comparator, Unsupported unsupported, Skipped skip) {
        TextBuilder sb = new TextBuilder();
        try {
            WrapperClassGenerator.generateWrapper(clazz, wrappedField, sb, comparator, unsupported, skip);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return sb.toString();
    }

    private static void generateWrapper(Class<?> clazz, String wrappedField, TextBuilder sb, MethodComparator comparator, Unsupported unsupported, Skipped skipped) throws Exception {
        sb.appendln(2);
        sb.append("// " + clazz.getName());
        Method[] declaredMethods = clazz.getDeclaredMethods();
        Arrays.sort(declaredMethods, comparator);
        for (Method method : declaredMethods) {
            int i;
            if (skipped.apply(method)) continue;
            String returnType = method.getGenericReturnType().getTypeName();
            sb.appendln(2);
            sb.append("@Override");
            sb.appendln();
            sb.append("public ");
            TypeVariable<Method>[] typeVars = method.getTypeParameters();
            if (typeVars.length > 0) {
                boolean first = true;
                sb.append(Character.valueOf('<'));
                for (TypeVariable<Method> tv : typeVars) {
                    if (!first) {
                        sb.append(Character.valueOf(','));
                    }
                    sb.append(tv.toString());
                    first = false;
                }
                sb.append("> ");
            }
            sb.append(returnType).append(" ").append(method.getName());
            sb.append("(");
            Parameter[] params = method.getParameters();
            for (int i2 = 0; i2 < params.length; ++i2) {
                if (i2 > 0) {
                    sb.append(", ");
                }
                Parameter parameter = params[i2];
                sb.append(parameter.getParameterizedType().getTypeName()).append(" ").append(parameter.getName());
            }
            sb.append(")");
            Class<?>[] exceptionTypes = method.getExceptionTypes();
            if (exceptionTypes.length > 0) {
                sb.append(" throws ");
            }
            for (i = 0; i < exceptionTypes.length; ++i) {
                sb.append(exceptionTypes[i].getCanonicalName());
                if (i >= exceptionTypes.length - 1) continue;
                sb.append(", ");
            }
            sb.append(" {");
            sb.appendln();
            if (unsupported != null && unsupported.apply(method)) {
                sb.appendtab().append("throw new UnsupportedOperationException();");
            } else {
                if (method.getReturnType() == Void.TYPE) {
                    sb.appendtab().append(wrappedField).append(".").append(method.getName());
                } else {
                    sb.appendtab().append("return ").append(wrappedField).append(".").append(method.getName());
                }
                sb.append("(");
                for (i = 0; i < params.length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    Parameter parameter = params[i];
                    sb.append(parameter.getName());
                }
                sb.append(");");
            }
            sb.appendln();
            sb.append("}");
        }
        if (clazz.getSuperclass() != null && clazz.getSuperclass() != Object.class) {
            WrapperClassGenerator.generateWrapper(clazz.getSuperclass(), wrappedField, sb, comparator, unsupported, skipped);
        }
        for (GenericDeclaration genericDeclaration : clazz.getInterfaces()) {
            WrapperClassGenerator.generateWrapper(genericDeclaration, wrappedField, sb, comparator, unsupported, skipped);
        }
    }

    private static Integer findMethodOrder(String methodName, Map<String, Integer> namePriorityMap) {
        if (namePriorityMap == null) {
            return null;
        }
        for (Map.Entry<String, Integer> entry : namePriorityMap.entrySet()) {
            if (!methodName.toLowerCase().contains(entry.getKey().toLowerCase())) continue;
            return entry.getValue();
        }
        return null;
    }

    public static class MethodComparator
    implements Comparator<Method> {
        final String[] priorities;
        final Map<String, Integer> namePriorityMap;

        public MethodComparator(String[] priorities) {
            this(priorities, null);
        }

        public MethodComparator(String[] priorities, Map<String, Integer> namePriorityMap) {
            this.priorities = priorities;
            this.namePriorityMap = namePriorityMap;
        }

        @Override
        public int compare(Method m1, Method m2) {
            for (String priority : this.priorities) {
                if (m1.getName().startsWith(priority) && !m2.getName().startsWith(priority)) {
                    return -1;
                }
                if (m1.getName().startsWith(priority) || !m2.getName().startsWith(priority)) continue;
                return 1;
            }
            Integer order1 = WrapperClassGenerator.findMethodOrder(m1.getName(), this.namePriorityMap);
            Integer order2 = WrapperClassGenerator.findMethodOrder(m2.getName(), this.namePriorityMap);
            if (order1 != null && order2 != null) {
                return order1.compareTo(order2);
            }
            if (order1 != null) {
                return -1;
            }
            if (order2 != null) {
                return 1;
            }
            int compare = m1.getName().compareTo(m2.getName());
            if (compare != 0) {
                return compare;
            }
            if (m1.getParameterCount() < m2.getParameterCount()) {
                return -1;
            }
            if (m1.getParameterCount() > m2.getParameterCount()) {
                return 1;
            }
            return m1.toString().compareTo(m2.toString());
        }
    }

    public static interface Skipped {
        public boolean apply(Method var1);
    }

    public static interface Unsupported {
        public boolean apply(Method var1);
    }
}

