/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.utils.AssertUtils;
import java.util.Arrays;

public class ValueUtils {
    public static int valueOrMin(Integer checkValue, int min) {
        if (checkValue == null || checkValue < min) {
            return min;
        }
        return checkValue;
    }

    public static long valueOrMin(Long checkValue, long min) {
        if (checkValue == null || checkValue < min) {
            return min;
        }
        return checkValue;
    }

    public static int valueOrMax(Integer checkValue, int max) {
        if (checkValue == null || checkValue > max) {
            return max;
        }
        return checkValue;
    }

    public static long valueOrMax(Long checkValue, long max) {
        if (checkValue == null || checkValue > max) {
            return max;
        }
        return checkValue;
    }

    public static int inRange(Integer checkValue, int min, int max) {
        if (checkValue == null || checkValue < min) {
            return min;
        }
        if (checkValue > max) {
            return max;
        }
        return checkValue;
    }

    public static long inRange(Long checkValue, long min, long max) {
        if (checkValue == null || checkValue < min) {
            return min;
        }
        if (checkValue > max) {
            return max;
        }
        return checkValue;
    }

    public static double inRange(Double checkValue, double min, double max) {
        if (checkValue == null || Double.compare(checkValue, min) < 0) {
            return min;
        }
        if (Double.compare(checkValue, max) > 0) {
            return max;
        }
        return checkValue;
    }

    public static <T> T validOrNull(T checkValue, T[] validValues) {
        AssertUtils.assertHasElements(validValues);
        if (checkValue == null) {
            return null;
        }
        if (Arrays.stream(validValues).anyMatch(v -> checkValue.equals(v))) {
            return checkValue;
        }
        return null;
    }

    public static <T> T valueOrAlt(T checkValue, T altValue) {
        return checkValue != null ? checkValue : altValue;
    }

    public static int valueOrAlt(int checkValue, int altValue) {
        return checkValue != 0 ? checkValue : altValue;
    }

    public static long valueOrAlt(long checkValue, long altValue) {
        return checkValue != 0L ? checkValue : altValue;
    }

    public static boolean isFloatRange(double value) {
        double posDouble;
        double d = posDouble = value >= 0.0 ? value : value * -1.0;
        return posDouble == 0.0 || !(posDouble < (double)1.4E-45f) && !(posDouble > 3.4028234663852886E38);
    }

    public static boolean isIntRange(long value) {
        return value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE;
    }

    public static boolean isShortRange(long value) {
        return value >= -32768L && value <= 32767L;
    }

    public static boolean isByteRange(long value) {
        return value >= -128L && value <= 127L;
    }
}

