/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.utils.ArrayUtils;
import com.appslandia.common.utils.StringFormat;
import com.appslandia.common.utils.URLEncoding;
import java.lang.reflect.Array;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;

public class URLUtils {
    public static String toQueryParams(Map<String, Object> parameterMap) {
        StringBuilder sb = new StringBuilder(parameterMap.size() * 16);
        for (Map.Entry<String, Object> param : parameterMap.entrySet()) {
            if (sb.length() > 0) {
                sb.append('&');
            }
            URLUtils.addQueryParam(sb, param.getKey(), param.getValue());
        }
        return sb.toString();
    }

    public static void addQueryParam(StringBuilder sb, String name, Object value) {
        if (value == null) {
            sb.append(URLEncoding.encodeParam(name)).append('=');
            return;
        }
        if (!value.getClass().isArray()) {
            sb.append(URLEncoding.encodeParam(name)).append('=').append(URLEncoding.encodeParam(value.toString()));
            return;
        }
        int len = Array.getLength(value);
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append('&');
            }
            sb.append(URLEncoding.encodeParam(name)).append('=');
            Object subVal = Array.get(value, i);
            if (subVal == null) continue;
            sb.append(URLEncoding.encodeParam(subVal.toString()));
        }
    }

    public static String toUrl(String url, Map<String, Object> moreParameters) {
        try {
            URI oldUri = new URI(url);
            Object newQuery = oldUri.getQuery();
            newQuery = newQuery == null ? URLUtils.toQueryParams(moreParameters) : (String)newQuery + "&" + URLUtils.toQueryParams(moreParameters);
            URI newUri = new URI(oldUri.getScheme(), oldUri.getAuthority(), oldUri.getPath(), (String)newQuery, oldUri.getFragment());
            return newUri.toString();
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static Map<String, Object> parseParams(String queryString, Map<String, Object> params) throws IllegalArgumentException {
        return URLUtils.parseParams(queryString, params, true);
    }

    public static Map<String, Object> parseParams(String queryString, Map<String, Object> params, boolean parseArray) throws IllegalArgumentException {
        String pair;
        int endIdx;
        if (queryString == null) {
            return params;
        }
        int startIdx = 0;
        while ((endIdx = queryString.indexOf(38, startIdx)) != -1) {
            pair = queryString.substring(startIdx, endIdx);
            if (!URLUtils.parsePair(pair, params, parseArray)) {
                throw new IllegalArgumentException(StringFormat.fmt("queryString is invalid: {}", queryString));
            }
            startIdx = endIdx + 1;
        }
        if (startIdx < queryString.length() && !URLUtils.parsePair(pair = queryString.substring(startIdx), params, parseArray)) {
            throw new IllegalArgumentException(StringFormat.fmt("queryString is invalid: {}", queryString));
        }
        return params;
    }

    private static boolean parsePair(String pair, Map<String, Object> params, boolean parseArray) {
        String decodedVal;
        int idx = pair.indexOf(61);
        if (idx <= 0) {
            return false;
        }
        String name = URLEncoding.decodeParam(pair.substring(0, idx));
        String value = pair.substring(idx + 1);
        String string = decodedVal = !value.isEmpty() ? URLEncoding.decodeParam(value) : null;
        if (!parseArray) {
            params.putIfAbsent(name, decodedVal);
            return true;
        }
        if (!params.containsKey(name)) {
            params.put(name, decodedVal);
        } else {
            Object addedValue = params.get(name);
            if (addedValue == null || addedValue.getClass() == String.class) {
                params.put(name, new String[]{(String)addedValue, decodedVal});
            } else {
                params.put(name, ArrayUtils.append((String[])addedValue, new String[]{decodedVal}));
            }
        }
        return true;
    }
}

