/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.base.Out;
import com.appslandia.common.jdbc.LikeType;
import com.appslandia.common.jdbc.SqlLikeEscaper;
import com.appslandia.common.utils.NormalizeUtils;
import com.appslandia.common.utils.SplitUtils;
import com.appslandia.common.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

public class TagUtils {
    static final Pattern TAGS_PATTEN = Pattern.compile("[^,]+(\\s*,\\s*[^,]*)*", 2);
    public static final String TBD_TAG = "#tbd";
    public static final String UNSORTED_TAG = "#unsorted";

    public static List<String> toTags(String tags, Out<Boolean> isValid) {
        ArrayList<String> result = new ArrayList<String>();
        isValid.value = true;
        if (tags == null) {
            return result;
        }
        if (TBD_TAG.equals(tags)) {
            result.add(TBD_TAG);
            return result;
        }
        if (UNSORTED_TAG.equals(tags)) {
            result.add(UNSORTED_TAG);
            return result;
        }
        if (!TAGS_PATTEN.matcher(tags).matches()) {
            isValid.value = false;
            return result;
        }
        Out<Boolean> valid = new Out<Boolean>();
        for (String tag : SplitUtils.split(tags, ',')) {
            if ((tag = TagUtils.toTag(tag, valid)) == null || result.contains(tag)) continue;
            result.add(tag);
        }
        if (result.isEmpty()) {
            isValid.value = false;
        }
        boolean hasTbd = result.remove(TBD_TAG);
        if (result.contains(UNSORTED_TAG)) {
            result.removeIf(t -> !t.equals(UNSORTED_TAG));
        }
        if (hasTbd) {
            result.add(0, TBD_TAG);
        }
        return result;
    }

    public static String toTag(String tag, Out<Boolean> isValid) {
        isValid.value = true;
        if (tag == null) {
            return null;
        }
        if (TBD_TAG.equals(tag)) {
            return TBD_TAG;
        }
        if (UNSORTED_TAG.equals(tag)) {
            return UNSORTED_TAG;
        }
        String nmlTag = NormalizeUtils.normalizeLabel(tag = tag.toLowerCase(Locale.ROOT));
        if (nmlTag == null) {
            isValid.value = false;
            return null;
        }
        return "#" + nmlTag;
    }

    public static String[] toTags(String dbTags) {
        return SplitUtils.split(dbTags, '|');
    }

    public static String toDispTags(String dbTags) {
        return String.join((CharSequence)", ", TagUtils.toTags(dbTags));
    }

    public static String wrapTag(String tag) {
        return "|" + tag + "|";
    }

    public static String toDbTags(Collection<String> tags) {
        return StringUtils.join('|', true, tags);
    }

    public static String toTagLikeVal(String tag) {
        return SqlLikeEscaper.toLikePattern(TagUtils.wrapTag(tag), LikeType.CONTAINS);
    }
}

