/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.base.LruMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public class TagList
implements Iterable<String> {
    final Collection<String> preTags;
    final Set<String> tags;

    public TagList() {
        this(Collections.emptySet());
    }

    public TagList(Collection<String> preTags) {
        this(preTags, 32);
    }

    public TagList(Collection<String> preTags, int maxSize) {
        this.preTags = preTags;
        this.tags = Collections.newSetFromMap(new LruMap(maxSize));
    }

    public boolean add(String tag) {
        if (tag == null) {
            return false;
        }
        if (this.preTags.contains(tag)) {
            return false;
        }
        return this.tags.add(tag);
    }

    public boolean remove(String tag) {
        if (tag == null) {
            return false;
        }
        if (this.preTags.contains(tag)) {
            return false;
        }
        return this.tags.remove(tag);
    }

    public boolean isPreTag(String tag) {
        return this.preTags.contains(tag);
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            final Iterator<String> it1;
            final Iterator<String> it2;
            {
                this.it1 = TagList.this.preTags.iterator();
                this.it2 = TagList.this.tags.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it1.hasNext() || this.it2.hasNext();
            }

            @Override
            public String next() {
                if (this.it1.hasNext()) {
                    return this.it1.next();
                }
                return this.it2.next();
            }
        };
    }
}

