/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.ObjectUtils;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.regex.Pattern;

public class StringUtils {
    public static final String EMPTY_STRING = "";
    public static final String[] EMPTY_ARRAY = new String[0];
    public static final String DOUBLE_LINE_SEP = System.lineSeparator() + System.lineSeparator();
    private static final Pattern WTSP_PATTERN = Pattern.compile("\\s+");

    public static String toLowerCase(String str, Locale locale) {
        if (str == null) {
            return null;
        }
        return str.toLowerCase(locale);
    }

    public static String toUpperCase(String str, Locale locale) {
        if (str == null) {
            return null;
        }
        return str.toUpperCase(locale);
    }

    public static String firstLowerCase(String str, Locale locale) {
        if (str == null) {
            return null;
        }
        if (!str.isEmpty()) {
            StringBuilder sb = new StringBuilder(str.length());
            return sb.append(str.substring(0, 1).toLowerCase(locale)).append(str.substring(1)).toString();
        }
        return str;
    }

    public static String firstUpperCase(String str, Locale locale) {
        if (str == null) {
            return null;
        }
        if (!str.isEmpty()) {
            StringBuilder sb = new StringBuilder(str.length());
            return sb.append(str.substring(0, 1).toUpperCase(locale)).append(str.substring(1)).toString();
        }
        return str;
    }

    public static String trimToNull(String str) {
        return StringUtils.trimToDefault(str, null);
    }

    public static String trimToEmpty(String str) {
        return str != null ? str.trim() : EMPTY_STRING;
    }

    public static String trimToDefault(String str, String defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        return !(str = str.trim()).isEmpty() ? str : defaultValue;
    }

    public static String trimToNull(String str, char charToTrim) {
        if (str == null) {
            return null;
        }
        int start = -1;
        while (++start < str.length() && str.charAt(start) == charToTrim) {
        }
        int end = str.length();
        while (--end >= 0 && str.charAt(end) == charToTrim) {
        }
        if (start > end) {
            return null;
        }
        return str.substring(start, end + 1);
    }

    public static String nullOrLowerCase(String str, Locale locale) {
        if (str == null) {
            return null;
        }
        return !str.isEmpty() ? str.toLowerCase(locale) : null;
    }

    public static String nullOrUpperCase(String str, Locale locale) {
        if (str == null) {
            return null;
        }
        return !str.isEmpty() ? str.toUpperCase(locale) : null;
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean isNullOrBlank(String str) {
        return str == null || str.isEmpty() || WTSP_PATTERN.matcher(str).matches();
    }

    public static boolean startsWithIgnoreCase(String str, String substr) {
        AssertUtils.assertNotNull(str);
        AssertUtils.assertNotNull(substr);
        if (substr.isEmpty()) {
            return true;
        }
        return str.regionMatches(true, 0, substr, 0, substr.length());
    }

    public static boolean endsWithIgnoreCase(String str, String substr) {
        AssertUtils.assertNotNull(str);
        AssertUtils.assertNotNull(substr);
        if (substr.isEmpty()) {
            return true;
        }
        return str.regionMatches(true, str.length() - substr.length(), substr, 0, substr.length());
    }

    public static boolean containsIgnoreCase(String str, String substr) {
        AssertUtils.assertNotNull(str);
        AssertUtils.assertNotNull(substr);
        if (substr.isEmpty()) {
            return true;
        }
        int maxOffset = str.length() - substr.length();
        for (int offset = 0; offset <= maxOffset; ++offset) {
            if (!str.regionMatches(true, offset, substr, 0, substr.length())) continue;
            return true;
        }
        return false;
    }

    public static String join(char delimiter, boolean willWrap, Iterable<? extends CharSequence> elements) {
        Collection col;
        Objects.requireNonNull(elements);
        if (elements instanceof Collection && (col = (Collection)ObjectUtils.cast(elements)).isEmpty()) {
            return null;
        }
        String sep = new String(new char[]{delimiter});
        StringJoiner joiner = willWrap ? new StringJoiner(sep, sep, sep) : new StringJoiner(sep);
        for (CharSequence charSequence : elements) {
            joiner.add(charSequence);
        }
        return joiner.toString();
    }

    public static String join(char delimiter, boolean willWrap, CharSequence ... elements) {
        Objects.requireNonNull(elements);
        if (elements.length == 0) {
            return null;
        }
        String sep = new String(new char[]{delimiter});
        StringJoiner joiner = willWrap ? new StringJoiner(sep, sep, sep) : new StringJoiner(sep);
        for (CharSequence cs : elements) {
            joiner.add(cs);
        }
        return joiner.toString();
    }
}

