/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.ObjectUtils;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringFormat {
    public static final Object MISSED_VALUE = new Object(){};
    private static final Pattern PARAM_HOLDER_PATTERN = Pattern.compile("\\$\\{\\s*[a-z\\d._]+\\s*}", 2);
    private static final Pattern SEQ_HOLDER_PATTERN = Pattern.compile("\\{}");

    public static String format(String str, Map<String, Object> parameters) {
        if (str == null) {
            return null;
        }
        return StringFormat.format(str, (String pname, String expr) -> parameters.containsKey(pname) ? parameters.get(pname) : MISSED_VALUE);
    }

    public static String format(String str, Object ... parameters) {
        if (str == null) {
            return null;
        }
        return StringFormat.format(str, (String pname, String expr) -> {
            int index = -1;
            try {
                index = Integer.parseInt(pname);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return 0 <= index && index < parameters.length ? parameters[index] : MISSED_VALUE;
        });
    }

    public static String format(String str, BiFunction<String, String, Object> parameters) {
        if (str == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder((int)(1.5 * (double)str.length()));
        StringFormat.format(str, parameters, sb);
        return sb.toString();
    }

    public static void format(String str, BiFunction<String, String, Object> parameters, StringBuilder out) {
        AssertUtils.assertNotNull(str);
        Matcher matcher = PARAM_HOLDER_PATTERN.matcher(str);
        int prevEnd = 0;
        while (matcher.find()) {
            if (prevEnd == 0) {
                out.append(str.substring(0, matcher.start()));
            } else {
                out.append(str.substring(prevEnd, matcher.start()));
            }
            String parameterGroup = matcher.group();
            String parameterName = parameterGroup.substring(parameterGroup.indexOf(123) + 1, parameterGroup.length() - 1).trim();
            Object parameterValue = parameters.apply(parameterName, parameterGroup);
            if (parameterValue == MISSED_VALUE) {
                out.append("${}");
            } else if (parameterValue == null) {
                out.append("null");
            } else if (parameterValue instanceof Iterable) {
                out.append(ObjectUtils.asString((Iterable)parameterValue));
            } else if (parameterValue.getClass().isArray()) {
                out.append(ObjectUtils.asString(parameterValue));
            } else {
                out.append(parameterValue.toString());
            }
            prevEnd = matcher.end();
        }
        if (prevEnd < str.length()) {
            out.append(str.substring(prevEnd));
        }
    }

    public static String fmt(String str, Object ... entries) {
        if (str == null) {
            return null;
        }
        StringBuilder out = new StringBuilder(str.length() + entries.length * 16);
        Matcher matcher = SEQ_HOLDER_PATTERN.matcher(str);
        int index = -1;
        int prevEnd = 0;
        while (matcher.find()) {
            Object entryValue;
            if (prevEnd == 0) {
                out.append(str.substring(0, matcher.start()));
            } else {
                out.append(str.substring(prevEnd, matcher.start()));
            }
            Object object = entryValue = 0 <= ++index && index < entries.length ? entries[index] : MISSED_VALUE;
            if (entryValue == MISSED_VALUE) {
                out.append("{}");
            } else if (entryValue == null) {
                out.append("null");
            } else if (entryValue instanceof Iterable) {
                out.append(ObjectUtils.asString((Iterable)entryValue));
            } else if (entryValue.getClass().isArray()) {
                out.append(ObjectUtils.asString(entryValue));
            } else {
                out.append(entryValue.toString());
            }
            prevEnd = matcher.end();
        }
        if (prevEnd < str.length()) {
            out.append(str.substring(prevEnd));
        }
        return out.toString();
    }
}

