/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.utils.StringUtils;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class SplitUtils {
    private static final Pattern NEWLINE_SEP_PATTERN = Pattern.compile("(\r?\n)+");

    public static String[] splitByLine(String str) {
        return SplitUtils.split(str, NEWLINE_SEP_PATTERN);
    }

    public static String[] split(String str, Pattern separator) {
        if (str == null) {
            return StringUtils.EMPTY_ARRAY;
        }
        String[] items = separator.split(str);
        ArrayList<String> list = new ArrayList<String>(items.length);
        for (String item : items) {
            if ((item = item.trim()).isEmpty()) continue;
            list.add(item);
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] split(String str, char separator) {
        String item;
        int endIdx;
        if (str == null) {
            return StringUtils.EMPTY_ARRAY;
        }
        int startIdx = 0;
        ArrayList<String> list = new ArrayList<String>();
        while ((endIdx = str.indexOf(separator, startIdx)) != -1) {
            item = str.substring(startIdx, endIdx).trim();
            if (!item.isEmpty()) {
                list.add(item);
            }
            startIdx = endIdx + 1;
        }
        if (startIdx < str.length() && !(item = str.substring(startIdx).trim()).isEmpty()) {
            list.add(item);
        }
        return list.toArray(new String[list.size()]);
    }
}

