/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.base.Out;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.ParseUtils;
import com.appslandia.common.utils.StringFormat;
import com.appslandia.common.utils.StringUtils;
import java.util.Map;
import java.util.regex.Pattern;

public class SYS {
    private static final String ENV_VAL_EXPR_PATTERN = StringFormat.format("((${0})|((${0}\\s*,\\s*)?env.${0}))(\\:[^\\s]+.+)?", "[a-z\\d._]+");
    private static final Pattern ENV_VAL_HOLDER_PATTERN = Pattern.compile(StringFormat.format("\\$\\{\\s*${0}\\s*}", ENV_VAL_EXPR_PATTERN), 2);

    public static boolean getBoolProp(String key, boolean defaultValue) {
        String value = StringUtils.trimToNull(System.getProperty(key));
        return value != null ? ParseUtils.parseBool(value, defaultValue) : defaultValue;
    }

    public static int getIntProp(String key, int defaultValue) {
        String value = StringUtils.trimToNull(System.getProperty(key));
        return value != null ? ParseUtils.parseInt(value, defaultValue) : defaultValue;
    }

    public static long getLongProp(String key, long defaultValue) {
        String value = StringUtils.trimToNull(System.getProperty(key));
        return value != null ? ParseUtils.parseLong(value, defaultValue) : defaultValue;
    }

    public static double getDoubleProp(String key, double defaultValue) {
        String value = StringUtils.trimToNull(System.getProperty(key));
        return value != null ? ParseUtils.parseDouble(value, defaultValue) : defaultValue;
    }

    public static String getProp(String key) {
        return SYS.getProp(key, null);
    }

    public static String getProp(String key, String defaultValue) {
        String value = StringUtils.trimToNull(System.getProperty(key));
        return value != null ? value : defaultValue;
    }

    public static String getRequiredProp(String key) {
        String value = SYS.getProp(key, null);
        if (value == null) {
            throw new IllegalStateException("The property '" + key + "' doesn't have a value.");
        }
        return value;
    }

    public static String getEnv(String key) {
        return SYS.getEnv(key, null);
    }

    public static String getEnv(String key, String defaultValue) {
        String value = StringUtils.trimToNull(System.getenv(key));
        return value != null ? value : defaultValue;
    }

    public static String getRequiredEnv(String key) {
        String value = SYS.getEnv(key, null);
        if (value == null) {
            throw new IllegalStateException("The env." + key + " doesn't have a value.");
        }
        return value;
    }

    public static String resolveString(String str) throws IllegalStateException {
        if (str == null) {
            return null;
        }
        return StringFormat.format(str, (p, expr) -> {
            String resolvedValue = SYS.resolveExpr(expr, new Out<Boolean>());
            if (resolvedValue == null) {
                throw SYS.toNoValueExprException(expr);
            }
            return resolvedValue;
        });
    }

    public static String resolveString(String str, Map<String, Object> parameters) throws IllegalStateException {
        if (str == null) {
            return null;
        }
        return StringFormat.format(str, (pname, expr) -> {
            Object resolvedValue = parameters.get(pname);
            if (resolvedValue == null) {
                resolvedValue = SYS.resolveExpr(expr, new Out<Boolean>());
            }
            if (resolvedValue == null) {
                throw SYS.toNoValueExprException(expr);
            }
            return resolvedValue;
        });
    }

    public static String resolveString(String str, Object ... parameters) throws IllegalStateException {
        if (str == null) {
            return null;
        }
        return StringFormat.format(str, (pname, expr) -> {
            Object resolvedValue = null;
            try {
                int index = Integer.parseInt(pname);
                if (0 <= index && index < parameters.length) {
                    resolvedValue = parameters[index];
                }
            }
            catch (NumberFormatException ex) {
                resolvedValue = SYS.resolveExpr(expr, new Out<Boolean>());
            }
            if (resolvedValue == null) {
                throw SYS.toNoValueExprException(expr);
            }
            return resolvedValue;
        });
    }

    public static String resolveExpr(String valueOrExpr) throws IllegalStateException {
        AssertUtils.assertNotNull(valueOrExpr);
        String resolvedValue = SYS.resolveExpr(valueOrExpr, new Out<Boolean>());
        if (resolvedValue == null) {
            throw SYS.toNoValueExprException(valueOrExpr);
        }
        return resolvedValue;
    }

    public static String resolveExpr(String valueOrExpr, Out<Boolean> isExpr) {
        AssertUtils.assertNotNull(valueOrExpr);
        if (!ENV_VAL_HOLDER_PATTERN.matcher(valueOrExpr).matches()) {
            isExpr.value = Boolean.FALSE;
            return valueOrExpr;
        }
        isExpr.value = Boolean.TRUE;
        String expr = valueOrExpr.substring(2, valueOrExpr.length() - 1).trim();
        return SYS.resolve(expr);
    }

    private static String resolve(String expr) {
        int commaIdx = expr.indexOf(44);
        int colonIdx = expr.indexOf(58);
        if (commaIdx < 0) {
            if (colonIdx < 0) {
                if (StringUtils.startsWithIgnoreCase(expr, "env.")) {
                    return SYS.getEnv(expr.substring(4), null);
                }
                return SYS.getProp(expr, null);
            }
            String defaultValue = expr.substring(colonIdx + 1);
            String leftExpr = expr.substring(0, colonIdx);
            if (StringUtils.startsWithIgnoreCase(leftExpr, "env.")) {
                return SYS.getEnv(leftExpr.substring(4), defaultValue);
            }
            return SYS.getProp(leftExpr, defaultValue);
        }
        if (colonIdx < 0) {
            String val = SYS.getProp(expr.substring(0, commaIdx).trim(), null);
            if (val == null) {
                val = SYS.getEnv(expr.substring(commaIdx + 1).trim().substring(4), null);
            }
            return val;
        }
        String defaultValue = expr.substring(colonIdx + 1);
        String leftExpr = expr.substring(0, colonIdx);
        int leftCommaIdx = leftExpr.indexOf(44);
        if (leftCommaIdx < 0) {
            if (StringUtils.startsWithIgnoreCase(leftExpr, "env.")) {
                return SYS.getEnv(leftExpr.substring(4), defaultValue);
            }
            return SYS.getProp(leftExpr, defaultValue);
        }
        String val = SYS.getProp(leftExpr.substring(0, leftCommaIdx).trim(), null);
        if (val == null) {
            val = SYS.getEnv(leftExpr.substring(leftCommaIdx + 1).trim().substring(4), defaultValue);
        }
        return val;
    }

    public static IllegalStateException toNoValueExprException(String expr) {
        return new IllegalStateException("Can't resolve value for expression '" + expr + "'");
    }
}

