/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.base.UncheckedException;
import com.appslandia.common.utils.ObjectUtils;
import com.appslandia.common.utils.ReflectionException;
import com.appslandia.common.utils.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.IntStream;

public class ReflectionUtils {
    public static final Object[] EMPTY_OBJECTS = new Object[0];
    public static final Class<?>[] EMPTY_CLASSES = new Class[0];
    public static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];

    public static Field findField(Class<?> clazz, final String property) throws ReflectionException {
        return ReflectionUtils.traverse(clazz, new FieldHandler(){

            @Override
            public boolean matches(Field f) {
                if (f.getName().equals(property)) {
                    return true;
                }
                return f.getType() == Boolean.TYPE && f.getName().equals("is" + StringUtils.firstUpperCase(property, Locale.ENGLISH));
            }

            @Override
            public boolean handle(Field field) throws ReflectionException {
                return false;
            }
        });
    }

    public static Method findMethod(Class<?> clazz, final String methodName) throws ReflectionException {
        return ReflectionUtils.traverse(clazz, new MethodHandler(){

            @Override
            public boolean matches(Method m) {
                return m.getName().equals(methodName);
            }

            @Override
            public boolean handle(Method m) throws ReflectionException {
                return false;
            }
        });
    }

    public static List<Method> findMethods(Class<?> clazz, final String methodName, final Class<?> ... parameterTypes) throws ReflectionException {
        final ArrayList<Method> mths = new ArrayList<Method>();
        ReflectionUtils.traverse(clazz, new MethodHandler(){

            @Override
            public boolean matches(Method m) {
                if (!m.getName().equals(methodName)) {
                    return false;
                }
                if (parameterTypes.length != m.getParameterCount()) {
                    return false;
                }
                if (parameterTypes.length == 0) {
                    return true;
                }
                Class[] mpTypes = m.getParameterTypes();
                return IntStream.range(0, mpTypes.length).allMatch(idx -> mpTypes[idx].isAssignableFrom(parameterTypes[idx]));
            }

            @Override
            public boolean handle(Method m) throws ReflectionException {
                mths.add(m);
                return true;
            }
        });
        return mths;
    }

    public static Field traverse(Class<?> clazz, FieldHandler handler) throws ReflectionException {
        Field matched = null;
        while (clazz != null) {
            for (Field field : clazz.getDeclaredFields()) {
                if (!handler.matches(field)) continue;
                matched = field;
                if (handler.handle(field)) continue;
                return matched;
            }
            clazz = clazz.getSuperclass();
        }
        return matched;
    }

    public static Method traverse(Class<?> clazz, MethodHandler handler) throws ReflectionException {
        Method matched = null;
        while (clazz != null) {
            Method[] methods;
            for (Method m : methods = clazz.isInterface() ? clazz.getMethods() : clazz.getDeclaredMethods()) {
                if (!handler.matches(m)) continue;
                matched = m;
                if (handler.handle(m)) continue;
                return matched;
            }
            clazz = clazz.getSuperclass();
        }
        return matched;
    }

    public static <T extends Annotation> T findAnnotation(Class<?> clazz, Class<T> annotationClass) {
        while (clazz != null) {
            T t = clazz.getAnnotation(annotationClass);
            if (t != null) {
                return t;
            }
            for (Class<?> interfaceClass : clazz.getInterfaces()) {
                t = interfaceClass.getAnnotation(annotationClass);
                if (t == null) continue;
                return t;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public static Object invoke(Method m, Object obj, Object ... args) throws ReflectionException {
        try {
            return m.invoke(obj, args);
        }
        catch (ReflectiveOperationException ex) {
            throw new ReflectionException(ex);
        }
    }

    public static void set(Field m, Object obj, Object value) throws ReflectionException {
        try {
            m.set(obj, value);
        }
        catch (ReflectiveOperationException ex) {
            throw new ReflectionException(ex);
        }
    }

    public static Object get(Field m, Object obj) throws ReflectionException {
        try {
            return m.get(obj);
        }
        catch (ReflectiveOperationException ex) {
            throw new ReflectionException(ex);
        }
    }

    public static Class<?> getListArgType(Type genericType) {
        if (!(genericType instanceof ParameterizedType)) {
            return null;
        }
        Type[] types = ((ParameterizedType)genericType).getActualTypeArguments();
        if (types.length != 1) {
            return null;
        }
        Type type = types[0];
        if (!(type instanceof Class)) {
            return null;
        }
        return (Class)type;
    }

    public static Class<?>[] getMapArgTypes(Type genericType) {
        if (!(genericType instanceof ParameterizedType)) {
            return null;
        }
        Type[] types = ((ParameterizedType)genericType).getActualTypeArguments();
        if (types.length != 2) {
            return null;
        }
        Type kt = types[0];
        if (!(kt instanceof Class)) {
            return null;
        }
        Type vt = types[1];
        if (!(vt instanceof Class)) {
            return null;
        }
        return new Class[]{(Class)kt, (Class)vt};
    }

    public static <T> T newInstance(Class<T> clazz) throws ReflectionException {
        try {
            return clazz.getDeclaredConstructor(EMPTY_CLASSES).newInstance(EMPTY_OBJECTS);
        }
        catch (ReflectiveOperationException ex) {
            throw new ReflectionException(ex);
        }
        catch (SecurityException ex) {
            throw new UncheckedException(ex);
        }
    }

    public static <T> Class<? extends T> loadClass(String className, ClassLoader loader) throws ReflectionException {
        ClassLoader cl = loader != null ? loader : ReflectionUtils.getDefaultClassLoader();
        try {
            return (Class)ObjectUtils.cast(cl.loadClass(className));
        }
        catch (ReflectiveOperationException ex) {
            throw new ReflectionException(ex);
        }
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (cl == null && (cl = ReflectionUtils.class.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return cl;
    }

    public static boolean isImplementOf(Method implMth, Method interfaceMth) {
        return interfaceMth.getDeclaringClass().isAssignableFrom(implMth.getDeclaringClass()) && interfaceMth.getName().equals(implMth.getName()) && Arrays.equals(interfaceMth.getParameterTypes(), implMth.getParameterTypes());
    }

    public static Method getDeclaredMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return clazz.getDeclaredMethod(name, parameterTypes);
        }
        catch (ReflectiveOperationException ex) {
            throw new ReflectionException(ex);
        }
        catch (SecurityException ex) {
            throw new UncheckedException(ex);
        }
    }

    public static boolean isPublicConst(int modifier) {
        return Modifier.isPublic(modifier) && Modifier.isStatic(modifier) && Modifier.isFinal(modifier);
    }

    public static interface MethodHandler {
        public boolean matches(Method var1);

        public boolean handle(Method var1) throws ReflectionException;
    }

    public static interface FieldHandler {
        public boolean matches(Field var1);

        public boolean handle(Field var1) throws ReflectionException;
    }
}

