/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;

public class PatternUtils {
    public static final Pattern[] EMPTY_PATTERNS = new Pattern[0];

    public static Pattern[] compile(String ... regexs) {
        if (regexs.length == 0) {
            return EMPTY_PATTERNS;
        }
        return (Pattern[])Arrays.stream(regexs).map(regex -> Pattern.compile(regex)).toArray(Pattern[]::new);
    }

    public static boolean matches(Pattern[] patterns, String value) {
        return Arrays.stream(patterns).anyMatch(p -> p.matcher(value).matches());
    }

    public static boolean matches(Collection<Pattern> patterns, String value) {
        return patterns.stream().anyMatch(p -> p.matcher(value).matches());
    }
}

