/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.base.Out;

public class ParseUtils {
    public static boolean parseBool(String value, boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (ParseUtils.isTrueValue(value)) {
            return true;
        }
        if (ParseUtils.isFalseValue(value)) {
            return false;
        }
        return defaultValue;
    }

    public static int parseInt(String value, int defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public static long parseLong(String value, long defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public static float parseFloat(String value, float defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            float val = Float.parseFloat(value);
            return !Float.isNaN(val) ? val : defaultValue;
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public static double parseDouble(String value, double defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            double val = Double.parseDouble(value);
            return !Double.isNaN(val) ? val : defaultValue;
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public static boolean parseBool(String value, Out<Boolean> valid) {
        valid.value = Boolean.FALSE;
        if (value == null) {
            return false;
        }
        valid.value = Boolean.TRUE;
        if (ParseUtils.isTrueValue(value)) {
            return true;
        }
        if (ParseUtils.isFalseValue(value)) {
            return false;
        }
        valid.value = Boolean.FALSE;
        return false;
    }

    public static int parseInt(String value, Out<Boolean> valid) {
        valid.value = Boolean.FALSE;
        if (value == null) {
            return 0;
        }
        try {
            int val = Integer.parseInt(value);
            valid.value = Boolean.TRUE;
            return val;
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }

    public static long parseLong(String value, Out<Boolean> valid) {
        valid.value = Boolean.FALSE;
        if (value == null) {
            return 0L;
        }
        try {
            long val = Long.parseLong(value);
            valid.value = Boolean.TRUE;
            return val;
        }
        catch (NumberFormatException ex) {
            return 0L;
        }
    }

    public static float parseFloat(String value, Out<Boolean> valid) {
        valid.value = Boolean.FALSE;
        if (value == null) {
            return 0.0f;
        }
        try {
            float val = Float.parseFloat(value);
            valid.value = !Float.isNaN(val);
            return (Boolean)valid.value != false ? val : 0.0f;
        }
        catch (NumberFormatException ex) {
            return 0.0f;
        }
    }

    public static double parseDouble(String value, Out<Boolean> valid) {
        valid.value = Boolean.FALSE;
        if (value == null) {
            return 0.0;
        }
        try {
            double val = Double.parseDouble(value);
            valid.value = !Double.isNaN(val);
            return (Boolean)valid.value != false ? val : 0.0;
        }
        catch (NumberFormatException ex) {
            return 0.0;
        }
    }

    public static boolean isTrueValue(String value) {
        return "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value);
    }

    public static boolean isFalseValue(String value) {
        return "false".equalsIgnoreCase(value) || "no".equalsIgnoreCase(value);
    }
}

