/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.utils.ArrayUtils;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.StreamUtils;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Collectors;

public class ObjectUtils {
    public static final String NULL_STR = "null";

    public static String toStringOrEmpty(Object obj) {
        return obj != null ? obj.toString() : "";
    }

    public static String toStringOrNull(Object obj) {
        return obj != null ? obj.toString() : null;
    }

    public static <F, T> T cast(F obj) throws ClassCastException {
        return (T)obj;
    }

    public static boolean toStringEquals(Object a, Object b) {
        return Objects.equals(ObjectUtils.toStringOrNull(a), ObjectUtils.toStringOrNull(b));
    }

    public static String toHashInfo(Object obj) {
        if (obj == null) {
            return NULL_STR;
        }
        return obj.getClass().getName() + "@" + Integer.toHexString(obj.hashCode());
    }

    public static String asString(Object[] array) {
        if (array == null) {
            return NULL_STR;
        }
        return Arrays.stream(array).map(e -> ObjectUtils.toStringOrNull(e)).collect(Collectors.joining(", "));
    }

    public static String asString(Object array) {
        if (array != null) {
            AssertUtils.assertTrue(array.getClass().isArray());
        }
        if (array == null) {
            return NULL_STR;
        }
        return StreamUtils.stream(ArrayUtils.iterator(array)).map(e -> ObjectUtils.toStringOrNull(e)).collect(Collectors.joining(", "));
    }

    public static String asString(Iterable<?> iterable) {
        if (iterable == null) {
            return NULL_STR;
        }
        return StreamUtils.stream(iterable.iterator()).map(e -> ObjectUtils.toStringOrNull(e)).collect(Collectors.joining(", "));
    }

    public static String asString(Iterator<?> iterator) {
        if (iterator == null) {
            return NULL_STR;
        }
        return StreamUtils.stream(iterator).map(e -> ObjectUtils.toStringOrNull(e)).collect(Collectors.joining(", "));
    }

    public static String asString(Enumeration<?> enumeration) {
        if (enumeration == null) {
            return NULL_STR;
        }
        return StreamUtils.stream(enumeration).map(e -> ObjectUtils.toStringOrNull(e)).collect(Collectors.joining(", "));
    }
}

