/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.PatternUtils;
import com.appslandia.common.utils.StringUtils;
import java.text.Normalizer;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NormalizeUtils {
    private static DecomposedCharacterConverter decomposedCharacterConverter;
    private static final Pattern STRIP_ACCENTS_PATTERN;
    private static final Pattern[] WTSP_PUNCT_HYPHEN_PATTERNS;
    private static final Pattern[] WTSP_PATTERNS;
    private static final Pattern[] CRLF3_PATTERNS;
    private static final Pattern[] WTSP_PUNCT_PATTERNS;
    private static final Pattern[] NON_DIGITS_PATTERNS;

    public static void setDecomposedCharacterConverter(DecomposedCharacterConverter converter) {
        AssertUtils.assertNull(decomposedCharacterConverter);
        decomposedCharacterConverter = converter;
    }

    public static String unaccent(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder decomposed = new StringBuilder(Normalizer.normalize(text, Normalizer.Form.NFD));
        if (decomposedCharacterConverter != null) {
            for (int i = 0; i < decomposed.length(); ++i) {
                char converted = decomposedCharacterConverter.convert(decomposed.charAt(i));
                if (converted == decomposed.charAt(i)) continue;
                decomposed.deleteCharAt(i);
                decomposed.insert(i, converted);
            }
        }
        return STRIP_ACCENTS_PATTERN.matcher(decomposed).replaceAll("");
    }

    public static String normalizeLabel(String label) {
        label = NormalizeUtils.normalize(label, WTSP_PUNCT_HYPHEN_PATTERNS, '-');
        return StringUtils.toLowerCase(label, Locale.ROOT);
    }

    public static String normalizeText(String str) {
        return NormalizeUtils.normalize(str, WTSP_PATTERNS, ' ');
    }

    public static String normalizeTextML(String text) {
        if (text == null) {
            return null;
        }
        return NormalizeUtils.normalize(text, CRLF3_PATTERNS, StringUtils.DOUBLE_LINE_SEP);
    }

    public static String removeSp(String str) {
        if (str == null) {
            return null;
        }
        return NormalizeUtils.normalize(str, WTSP_PATTERNS, "");
    }

    public static String removeSpPunct(String str) {
        if (str == null) {
            return null;
        }
        return NormalizeUtils.normalize(str, WTSP_PUNCT_PATTERNS, "");
    }

    public static String digitOnly(String str) {
        if (str == null) {
            return null;
        }
        return NormalizeUtils.normalize(str, NON_DIGITS_PATTERNS, "");
    }

    public static String normalize(String str, Pattern[] matchers, char charReplacement) {
        if (str == null) {
            return null;
        }
        String replacement = new String(new char[]{charReplacement});
        for (Pattern p : matchers) {
            str = p.matcher(str).replaceAll(Matcher.quoteReplacement(replacement));
        }
        return StringUtils.trimToNull(str, charReplacement);
    }

    public static String normalize(String str, Pattern[] matchers, String replacement) {
        if (str == null) {
            return null;
        }
        for (Pattern p : matchers) {
            str = p.matcher(str).replaceAll(Matcher.quoteReplacement(replacement));
        }
        return StringUtils.trimToNull(str);
    }

    public static String keyValue(String str) {
        if (str == null) {
            return null;
        }
        str = NormalizeUtils.removeSpPunct(str);
        return StringUtils.toUpperCase(str, Locale.ROOT);
    }

    static {
        STRIP_ACCENTS_PATTERN = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
        WTSP_PUNCT_HYPHEN_PATTERNS = PatternUtils.compile("\\s+|\\p{Punct}+", "-{2,}");
        WTSP_PATTERNS = PatternUtils.compile("\\s+");
        CRLF3_PATTERNS = PatternUtils.compile("(\r?\n){3,}");
        WTSP_PUNCT_PATTERNS = PatternUtils.compile("\\s+|\\p{Punct}+");
        NON_DIGITS_PATTERNS = PatternUtils.compile("[^\\d]+");
    }

    public static interface DecomposedCharacterConverter {
        public char convert(char var1);
    }
}

