/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.ExceptionUtils;
import com.appslandia.common.utils.ReflectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Arrays;
import java.util.function.Function;

public class ModelUtils {
    public static <T> void copy(T dest, T src, Function<String, Boolean> forProps) throws ReflectionException {
        try {
            for (PropertyDescriptor dpd : Introspector.getBeanInfo(dest.getClass()).getPropertyDescriptors()) {
                if (!forProps.apply(dpd.getName()).booleanValue()) continue;
                AssertUtils.assertNotNull(dpd.getWriteMethod());
                AssertUtils.assertNotNull(dpd.getReadMethod());
                dpd.getWriteMethod().invoke(dest, dpd.getReadMethod().invoke(src, new Object[0]));
            }
        }
        catch (ReflectiveOperationException ex) {
            throw new ReflectionException(ex);
        }
        catch (Exception ex) {
            throw ExceptionUtils.toUncheckedException(ex);
        }
    }

    public static <T> void copy(T dest, T src, String ... forProps) throws ReflectionException {
        ModelUtils.copy(dest, src, (String prop) -> Arrays.stream(forProps).anyMatch(p -> p.equals(prop)));
    }

    public static <D, S> void copyProps(D dest, S src, Function<String, Boolean> forProps) throws ReflectionException {
        try {
            for (PropertyDescriptor dpd : Introspector.getBeanInfo(dest.getClass()).getPropertyDescriptors()) {
                if (!forProps.apply(dpd.getName()).booleanValue()) continue;
                AssertUtils.assertNotNull(dpd.getWriteMethod());
                PropertyDescriptor spd = null;
                for (PropertyDescriptor dp : Introspector.getBeanInfo(src.getClass()).getPropertyDescriptors()) {
                    if (!dp.getName().equals(dpd.getName())) continue;
                    spd = dp;
                    break;
                }
                AssertUtils.assertNotNull(spd);
                AssertUtils.assertNotNull(spd.getReadMethod());
                dpd.getWriteMethod().invoke(dest, spd.getReadMethod().invoke(src, new Object[0]));
            }
        }
        catch (ReflectiveOperationException ex) {
            throw new ReflectionException(ex);
        }
        catch (Exception ex) {
            throw ExceptionUtils.toUncheckedException(ex);
        }
    }

    public static <D, S> void copyProps(D dest, S src, String ... forProps) throws ReflectionException {
        ModelUtils.copyProps(dest, src, (String prop) -> Arrays.stream(forProps).anyMatch(p -> p.equals(prop)));
    }
}

