/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.utils.AssertUtils;
import java.util.Comparator;

public class MathUtils {
    public static boolean isPow2(long n) {
        if (n < 1L || n > 0x4000000000000000L) {
            return false;
        }
        return (n & n - 1L) == 0L;
    }

    public static int ceil(int n, int base) {
        AssertUtils.assertTrue(n >= 0);
        AssertUtils.assertTrue(base > 0);
        return (n + base - 1) / base * base;
    }

    public static byte[] toByteArray(int value) {
        byte[] bytes = new byte[4];
        for (int i = 3; i >= 0; --i) {
            bytes[i] = (byte)(value & 0xFF);
            value >>= 8;
        }
        return bytes;
    }

    public static int toInt(byte[] bytes) {
        return (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
    }

    public static byte[] toByteArray(long value) {
        byte[] bytes = new byte[8];
        for (int i = 7; i >= 0; --i) {
            bytes[i] = (byte)(value & 0xFFL);
            value >>= 8;
        }
        return bytes;
    }

    public static long toLong(byte[] bytes) {
        return ((long)bytes[0] & 0xFFL) << 56 | ((long)bytes[1] & 0xFFL) << 48 | ((long)bytes[2] & 0xFFL) << 40 | ((long)bytes[3] & 0xFFL) << 32 | ((long)bytes[4] & 0xFFL) << 24 | ((long)bytes[5] & 0xFFL) << 16 | ((long)bytes[6] & 0xFFL) << 8 | (long)bytes[7] & 0xFFL;
    }

    public static byte[] toByteArray(int begin, int end) {
        AssertUtils.assertTrue(begin <= end);
        byte[] byteArray = new byte[end - begin + 1];
        for (int i = begin; i <= end; ++i) {
            byteArray[i - begin] = (byte)i;
        }
        return byteArray;
    }

    public static <T> T min(T a, T b, Comparator<T> comparator) {
        return comparator.compare(a, b) <= 0 ? a : b;
    }

    public static <T> T max(T a, T b, Comparator<T> comparator) {
        return comparator.compare(a, b) <= 0 ? b : a;
    }
}

