/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

public class JsonEscaper {
    private static final int HIGHEST_SPECIAL = 92;
    private static char[][] ESCAPE_JSON = new char[93][];

    static void escapeControlChar(char c, StringBuilder out) {
        out.setLength(0);
        String hs = Integer.toHexString(c);
        out.append("\\u");
        for (int i = 0; i < 4 - hs.length(); ++i) {
            out.append('0');
        }
        out.append(hs);
    }

    public static String escapeValue(String s) {
        if (s == null) {
            return "null";
        }
        if (s.isEmpty()) {
            return "\"\"";
        }
        StringBuilder out = new StringBuilder((int)((float)s.length() * 1.25f));
        out.append('\"');
        int start = 0;
        char[] srcChars = s.toCharArray();
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char[] escaped;
            char c = srcChars[i];
            if (c > '\\' || (escaped = ESCAPE_JSON[c]) == null) continue;
            if (start < i) {
                out.append(srcChars, start, i - start);
            }
            out.append(escaped);
            start = i + 1;
        }
        if (start < length) {
            out.append(srcChars, start, length - start);
        }
        out.append('\"');
        return out.toString();
    }

    static {
        StringBuilder sb = new StringBuilder(6);
        for (char ch = '\u0000'; ch <= '\u001f'; ch = (char)(ch + '\u0001')) {
            JsonEscaper.escapeControlChar(ch, sb);
            JsonEscaper.ESCAPE_JSON[ch] = sb.toString().toCharArray();
        }
        JsonEscaper.ESCAPE_JSON[34] = "\\\"".toCharArray();
        JsonEscaper.ESCAPE_JSON[92] = "\\\\".toCharArray();
        JsonEscaper.ESCAPE_JSON[47] = "\\/".toCharArray();
        JsonEscaper.ESCAPE_JSON[8] = "\\b".toCharArray();
        JsonEscaper.ESCAPE_JSON[12] = "\\f".toCharArray();
        JsonEscaper.ESCAPE_JSON[10] = "\\n".toCharArray();
        JsonEscaper.ESCAPE_JSON[13] = "\\r".toCharArray();
        JsonEscaper.ESCAPE_JSON[9] = "\\t".toCharArray();
    }
}

