/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;

public class FileUtils {
    public static Path mkdirs(String dir) {
        Path path = Paths.get(dir, new String[0]);
        path.toFile().mkdirs();
        return path;
    }

    public static void writeContent(Path path, String content) throws IOException {
        FileUtils.writeContent(path, content, StandardCharsets.UTF_8);
    }

    public static void writeContent(Path path, String content, Charset charset) throws IOException {
        Files.write(path, Arrays.asList(content), charset, new OpenOption[0]);
    }

    public static String readContent(Path src) throws IOException {
        return FileUtils.readContent(src, StandardCharsets.UTF_8);
    }

    public static String readContent(Path path, Charset charset) throws IOException {
        return new String(Files.readAllBytes(path), charset);
    }

    public static void deleteRecursively(Path root) throws IOException {
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                try {
                    Files.delete(dir);
                }
                catch (DirectoryNotEmptyException directoryNotEmptyException) {
                    // empty catch block
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void copyRecursively(final Path src, final Path dest) throws IOException {
        BasicFileAttributes srcAttr = Files.readAttributes(src, BasicFileAttributes.class, new LinkOption[0]);
        if (srcAttr.isDirectory()) {
            Files.walkFileTree(src, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Files.createDirectories(dest.resolve(src.relativize(dir)), new FileAttribute[0]);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.copy(file, dest.resolve(src.relativize(file)), new CopyOption[0]);
                    return FileVisitResult.CONTINUE;
                }
            });
        } else if (srcAttr.isRegularFile()) {
            Files.copy(src, dest, new CopyOption[0]);
        } else {
            throw new IllegalArgumentException("src must denote a directory or file");
        }
    }
}

