/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.base.UUIDGenerator;
import com.appslandia.common.utils.DateUtils;
import com.appslandia.common.utils.NormalizeUtils;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public class FileNameUtils {
    private static final DateTimeFormatter FILENAME_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd-HHmmssSSS");

    public static String insertNow(String fileName) {
        return FileNameUtils.insertNow(fileName, "Z");
    }

    public static String insertNow(String fileName, String offsetId) {
        OffsetDateTime now = DateUtils.nowAt(offsetId);
        String nowNoZ = FILENAME_TIME_FORMATTER.format(now);
        if (now.getOffset().getTotalSeconds() < 0) {
            return FileNameUtils.insert(fileName, nowNoZ + "GMT-" + NormalizeUtils.removeSpPunct(now.getOffset().getId()));
        }
        if (now.getOffset().getTotalSeconds() > 0) {
            return FileNameUtils.insert(fileName, nowNoZ + "GMT" + NormalizeUtils.removeSpPunct(now.getOffset().getId()));
        }
        return FileNameUtils.insert(fileName, nowNoZ + "Z");
    }

    public static String insertUUID(String fileName) {
        return FileNameUtils.insert(fileName, UUIDGenerator.INSTANCE.generate());
    }

    public static String insert(String fileName, Object info) {
        int idx = fileName.lastIndexOf(46);
        if (idx != 0) {
            return info + "-" + fileName;
        }
        return info + fileName;
    }

    public static String toUnixPath(String path) {
        if (path == null || path.indexOf(92) == -1) {
            return path;
        }
        return path.replace('\\', '/');
    }
}

