/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.utils.AssertUtils;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeUtility;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;

public class EmailUtils {
    private static final Pattern EMAIL_PATTERN = Pattern.compile("(?=.{6,255}$)[_a-z\\d-\\+]+(\\.[_a-z\\d-]+)*@[a-z\\d-]+(\\.[a-z\\d-]+)*(\\.[a-z]{2,})", 2);

    public static boolean isValid(CharSequence email) {
        if (email == null) {
            return true;
        }
        return EMAIL_PATTERN.matcher(email).matches();
    }

    public static InternetAddress parseAddress(String email, String person) throws AddressException {
        AssertUtils.assertNotNull(email);
        InternetAddress address = new InternetAddress(email);
        if (person != null) {
            try {
                address.setPersonal(person, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException ex) {
                throw new Error(ex);
            }
        }
        return address;
    }

    public static String toPersonEmail(String email, String person) {
        AssertUtils.assertNotNull(email);
        if (person == null) {
            return email;
        }
        try {
            return String.format("%s <%s>", MimeUtility.encodeWord((String)person, (String)StandardCharsets.UTF_8.name(), null), email);
        }
        catch (UnsupportedEncodingException ex) {
            throw new Error(ex);
        }
    }
}

