/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class DecimalUtils {
    private static final double POSITIVE_ZERO = 0.0;

    public static double round(double x, int scale) {
        return DecimalUtils.round(x, scale, RoundingMode.HALF_UP);
    }

    public static double round(double x, int scale, RoundingMode roundingMode) {
        try {
            double roundedValue = new BigDecimal(Double.toString(x)).setScale(scale, roundingMode).doubleValue();
            return DecimalUtils.fixSign(roundedValue, x);
        }
        catch (NumberFormatException ex) {
            if (Double.isInfinite(x)) {
                return x;
            }
            return Double.NaN;
        }
    }

    public static double fixSign(double roundedValue, double x) {
        return roundedValue == 0.0 ? 0.0 * x : roundedValue;
    }

    public static boolean isDifferent(double d1, double d2, double delta) {
        if (Double.compare(d1, d2) == 0) {
            return false;
        }
        return !(Math.abs(d1 - d2) <= delta);
    }

    public static boolean isDifferent(float f1, float f2, float delta) {
        if (Float.compare(f1, f2) == 0) {
            return false;
        }
        return !(Math.abs(f1 - f2) <= delta);
    }
}

