/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.base.DateFormatException;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.StringUtils;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAdjusters;
import java.util.Calendar;
import java.util.EnumMap;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public class DateUtils {
    public static final String PATTERN_DATE = "yyyy-MM-dd";
    public static final String PATTERN_TIME = "HH:mm:ss.SSS";
    public static final String PATTERN_TIME_Z = "HH:mm:ss.SSSXXX";
    public static final String PATTERN_TIME_M = "HH:mm";
    public static final String PATTERN_TIME_MZ = "HH:mmXXX";
    public static final String PATTERN_DATETIME = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    public static final String PATTERN_DATETIME_Z = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
    public static final String PATTERN_DATETIME_M = "yyyy-MM-dd'T'HH:mm";
    public static final String PATTERN_DATETIME_MZ = "yyyy-MM-dd'T'HH:mmXXX";
    public static final String PATTERN_YEAR_MONTH = "yyyy-MM";
    private static final Pattern TEMPORAL_AMT_PATTERN = Pattern.compile("((\\d+.\\d+|\\d+)(w|d|h|m|s|ms)\\s*)+", 2);

    public static Date todaySqlDate() {
        return new Date(DateUtils.todayAsLong());
    }

    public static long todayAsLong() {
        return DateUtils.todayCalendar().getTimeInMillis();
    }

    public static Calendar todayCalendar() {
        GregorianCalendar cal = new GregorianCalendar();
        DateUtils.clearTime(cal);
        return cal;
    }

    public static Timestamp nowTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static long clearMs(long timeInMs) {
        return timeInMs / 1000L * 1000L;
    }

    public static java.util.Date clearMs(java.util.Date dt) {
        return new java.util.Date(DateUtils.clearMs(dt.getTime()));
    }

    public static long clearTime(long timeInMs) {
        return DateUtils.clearTime(new java.util.Date(timeInMs)).getTime();
    }

    public static java.util.Date clearTime(java.util.Date dt) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(dt);
        DateUtils.clearTime(cal);
        return cal.getTime();
    }

    public static void clearTime(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
    }

    public static Calendar getCalendar(int dayOfWeek, int atHour, int atMinute) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(7, dayOfWeek);
        cal.set(11, atHour);
        cal.set(12, atMinute);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public static java.util.Date copyTime(java.util.Date dest, java.util.Date src) {
        GregorianCalendar destCal = new GregorianCalendar();
        destCal.setTime(dest);
        GregorianCalendar srcCal = new GregorianCalendar();
        srcCal.setTime(src);
        destCal.set(11, srcCal.get(11));
        destCal.set(12, srcCal.get(12));
        destCal.set(13, srcCal.get(13));
        destCal.set(14, srcCal.get(14));
        return destCal.getTime();
    }

    public static boolean isFutureTime(long timeMillis, int leewayMs) {
        return System.currentTimeMillis() - (long)leewayMs < timeMillis;
    }

    public static boolean isPastTime(long timeMillis, int leewayMs) {
        return System.currentTimeMillis() + (long)leewayMs >= timeMillis;
    }

    public static String format(java.util.Date dt, String pattern) {
        return DateUtils.newDateFormat(pattern).format(dt);
    }

    public static SimpleDateFormat newDateFormat(String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        sdf.setLenient(false);
        return sdf;
    }

    public static Date iso8601Date(String date) throws DateFormatException {
        return date != null ? new Date(DateUtils.parse(date, PATTERN_DATE).getTime()) : null;
    }

    public static String iso8601Date(java.util.Date date) {
        return date != null ? DateUtils.newDateFormat(PATTERN_DATE).format(date) : null;
    }

    public static Time iso8601Time(String time) throws DateFormatException {
        return time != null ? new Time(DateUtils.parse(time, PATTERN_TIME).getTime()) : null;
    }

    public static String iso8601Time(java.util.Date time) {
        return time != null ? DateUtils.newDateFormat(PATTERN_TIME).format(time) : null;
    }

    public static Timestamp iso8601DateTime(String dateTime) throws DateFormatException {
        return dateTime != null ? new Timestamp(DateUtils.parse(dateTime, PATTERN_DATETIME).getTime()) : null;
    }

    public static String iso8601DateTime(java.util.Date dateTime) {
        return dateTime != null ? DateUtils.newDateFormat(PATTERN_DATETIME).format(dateTime) : null;
    }

    public static java.util.Date parse(String dt, String pattern) throws DateFormatException {
        try {
            return DateUtils.newDateFormat(pattern).parse(dt);
        }
        catch (ParseException ex) {
            throw new DateFormatException(ex);
        }
    }

    public static Integer toDateID(LocalDate ld) {
        if (ld == null) {
            return null;
        }
        return ld.getYear() * 10000 + ld.getMonthValue() * 100 + ld.getDayOfMonth();
    }

    public static LocalDate toLocalDate(java.util.Date date) {
        return date != null ? Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDate() : null;
    }

    public static DateTimeFormatter getFormatter(String pattern) {
        return DateTimeFormattersHolder.FORMATTERS.computeIfAbsent(pattern, p -> DateTimeFormatter.ofPattern(p));
    }

    public static OffsetDateTime nowAtUTC() {
        return DateUtils.nowAt(ZoneOffset.UTC);
    }

    public static LocalDateTime atStartOfDay(LocalDate ld) {
        return LocalDateTime.of(ld, LocalTime.MIN);
    }

    public static LocalDateTime atEndOfDay(LocalDate ld) {
        return LocalDateTime.of(ld, LocalTime.MAX);
    }

    public static OffsetDateTime nowAt(String offsetId) {
        return DateUtils.nowAt(ZoneOffset.of(offsetId));
    }

    public static OffsetDateTime nowAt(ZoneOffset offset) {
        return OffsetDateTime.now().withOffsetSameInstant(offset);
    }

    public static OffsetDateTime atUTC(OffsetDateTime odt) {
        return odt.withOffsetSameInstant(ZoneOffset.UTC);
    }

    public static LocalDate firstDayOfMonth(LocalDate ld) {
        return ld.with(TemporalAdjusters.firstDayOfMonth());
    }

    public static LocalDate lastDayOfMonth(LocalDate ld) {
        return ld.with(TemporalAdjusters.lastDayOfMonth());
    }

    public static LocalDateTime firstDayOfMonth(LocalDateTime ldt) {
        return ldt.with(TemporalAdjusters.firstDayOfMonth());
    }

    public static LocalDateTime lastDayOfMonth(LocalDateTime ldt) {
        return ldt.with(TemporalAdjusters.lastDayOfMonth());
    }

    public static OffsetDateTime firstDayOfMonth(OffsetDateTime odt) {
        return odt.with(TemporalAdjusters.firstDayOfMonth());
    }

    public static OffsetDateTime lastDayOfMonth(OffsetDateTime odt) {
        return odt.with(TemporalAdjusters.lastDayOfMonth());
    }

    public static LocalDate iso8601LocalDate(String date) throws DateTimeParseException {
        return date != null ? LocalDate.parse(date, DateUtils.getFormatter(PATTERN_DATE)) : null;
    }

    public static String iso8601LocalDate(LocalDate date) {
        return date != null ? DateUtils.getFormatter(PATTERN_DATE).format(date) : null;
    }

    public static LocalTime iso8601LocalTime(String time) throws DateTimeParseException {
        return time != null ? LocalTime.parse(time, DateUtils.getFormatter(PATTERN_TIME)) : null;
    }

    public static String iso8601LocalTime(LocalTime time) {
        return time != null ? DateUtils.getFormatter(PATTERN_TIME).format(time) : null;
    }

    public static LocalDateTime iso8601LocalDateTime(String dateTime) throws DateTimeParseException {
        return dateTime != null ? LocalDateTime.parse(dateTime, DateUtils.getFormatter(PATTERN_DATETIME)) : null;
    }

    public static String iso8601LocalDateTime(LocalDateTime dateTime) {
        return dateTime != null ? DateUtils.getFormatter(PATTERN_DATETIME).format(dateTime) : null;
    }

    public static OffsetTime iso8601OffsetTime(String timeZ) throws DateTimeParseException {
        return timeZ != null ? OffsetTime.parse(timeZ, DateUtils.getFormatter(PATTERN_TIME_Z)) : null;
    }

    public static String iso8601OffsetTime(OffsetTime timeZ) {
        return timeZ != null ? DateUtils.getFormatter(PATTERN_TIME_Z).format(timeZ) : null;
    }

    public static OffsetDateTime iso8601OffsetDateTime(String dateTimeZ) throws DateTimeParseException {
        return dateTimeZ != null ? OffsetDateTime.parse(dateTimeZ, DateUtils.getFormatter(PATTERN_DATETIME_Z)) : null;
    }

    public static String iso8601OffsetDateTime(OffsetDateTime dateTimeZ) {
        return dateTimeZ != null ? DateUtils.getFormatter(PATTERN_DATETIME_Z).format(dateTimeZ) : null;
    }

    public static long translateToMs(String temporalAmt) throws IllegalArgumentException {
        temporalAmt = StringUtils.trimToNull(temporalAmt);
        AssertUtils.assertNotNull(temporalAmt, "temporalAmt is required.");
        if (!TEMPORAL_AMT_PATTERN.matcher(temporalAmt).matches()) {
            throw new IllegalArgumentException("temporalAmt is invalid (value=" + temporalAmt + ")");
        }
        double result = 0.0;
        int i = 0;
        while (i < temporalAmt.length()) {
            String unit;
            int k;
            int j = i;
            while (Character.isDigit(temporalAmt.charAt(j)) || temporalAmt.charAt(j) == '.') {
                ++j;
            }
            for (k = j; k <= temporalAmt.length() - 1 && (Character.isLetter(temporalAmt.charAt(k)) || temporalAmt.charAt(k) == ' '); ++k) {
            }
            double amt = Double.parseDouble(temporalAmt.substring(i, j));
            switch (unit = temporalAmt.substring(j, k).trim().toLowerCase(Locale.ENGLISH)) {
                case "w": {
                    result += (double)(TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS) * 7L) * amt;
                    break;
                }
                case "d": {
                    result += (double)TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS) * amt;
                    break;
                }
                case "h": {
                    result += (double)TimeUnit.MILLISECONDS.convert(1L, TimeUnit.HOURS) * amt;
                    break;
                }
                case "m": {
                    result += (double)TimeUnit.MILLISECONDS.convert(1L, TimeUnit.MINUTES) * amt;
                    break;
                }
                case "s": {
                    result += (double)TimeUnit.MILLISECONDS.convert(1L, TimeUnit.SECONDS) * amt;
                    break;
                }
                default: {
                    result += amt;
                }
            }
            i = k;
        }
        return (long)Math.ceil(result);
    }

    public static Map<TimeUnit, Long> parseUnits(long duration, TimeUnit unit) {
        return DateUtils.parseUnits(duration, unit, TimeUnit.DAYS, TimeUnit.NANOSECONDS);
    }

    public static Map<TimeUnit, Long> parseUnits(long duration, TimeUnit unit, TimeUnit highUnit, TimeUnit lowUnit) {
        AssertUtils.assertTrue(highUnit.compareTo(lowUnit) >= 0, "highUnit must be gte lowUnit.");
        EnumMap<TimeUnit, Long> res = new EnumMap<TimeUnit, Long>(TimeUnit.class);
        duration = lowUnit.convert(duration, unit);
        TimeUnit u = highUnit;
        while (true) {
            long v = u.convert(duration, lowUnit);
            res.put(u, v);
            if (u == lowUnit) break;
            duration -= lowUnit.convert(v, u);
            u = DateUtils.nextLowerUnit(u);
        }
        return res;
    }

    public static TimeUnit nextLowerUnit(TimeUnit unit) {
        switch (unit) {
            case DAYS: {
                return TimeUnit.HOURS;
            }
            case HOURS: {
                return TimeUnit.MINUTES;
            }
            case MINUTES: {
                return TimeUnit.SECONDS;
            }
            case SECONDS: {
                return TimeUnit.MILLISECONDS;
            }
            case MILLISECONDS: {
                return TimeUnit.MICROSECONDS;
            }
            case MICROSECONDS: {
                return TimeUnit.NANOSECONDS;
            }
        }
        throw new Error();
    }

    private static final class DateTimeFormattersHolder {
        private static final ConcurrentMap<String, DateTimeFormatter> FORMATTERS = new ConcurrentHashMap<String, DateTimeFormatter>();

        private DateTimeFormattersHolder() {
        }
    }
}

