/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.utils.AssertUtils;
import java.util.ArrayList;

public class CsvEscaper
extends InitializeObject {
    private boolean writeNull;
    private char separator = (char)44;
    private boolean escCrLf;

    @Override
    protected void init() throws Exception {
    }

    public CsvEscaper writeNull() {
        this.assertNotInitialized();
        this.writeNull = true;
        return this;
    }

    public CsvEscaper separator(char separator) {
        this.assertNotInitialized();
        this.separator = separator;
        return this;
    }

    public CsvEscaper escCrLf() {
        this.assertNotInitialized();
        this.escCrLf = true;
        return this;
    }

    public String escapeValue(String s) {
        this.initialize();
        if (s == null) {
            if (this.writeNull) {
                return "null";
            }
            return "";
        }
        if (s.isEmpty()) {
            return "";
        }
        StringBuilder out = new StringBuilder((int)((float)s.length() * 1.25f));
        out.append('\"');
        int start = 0;
        char[] srcChars = s.toCharArray();
        int length = s.length();
        boolean useWrap = false;
        for (int i = 0; i < length; ++i) {
            char c = srcChars[i];
            if (!useWrap) {
                boolean bl = useWrap = c == '\"' || c == '\r' || c == '\n' || c == this.separator;
            }
            if (c == '\"') {
                if (start < i) {
                    out.append(srcChars, start, i - start);
                }
                out.append("\"\"");
                start = i + 1;
                continue;
            }
            if (!this.escCrLf || c != '\r' && c != '\n') continue;
            if (start < i) {
                out.append(srcChars, start, i - start);
            }
            out.append("\\").append(c == '\r' ? (char)'r' : 'n');
            start = i + 1;
        }
        if (start < length) {
            out.append(srcChars, start, length - start);
        }
        out.append('\"');
        return useWrap ? out.toString() : s;
    }

    public String[] parseValues(String csvRecord) throws IllegalArgumentException {
        AssertUtils.assertNotNull(csvRecord);
        ArrayList<String> values = new ArrayList<String>();
        int i = 0;
        while (i <= csvRecord.length()) {
            int j;
            if (i == csvRecord.length()) {
                values.add(null);
                break;
            }
            if (csvRecord.charAt(i) == '\"') {
                j = i + 1;
                boolean closingQuote = false;
                while (j < csvRecord.length()) {
                    if (csvRecord.charAt(j) == '\"') {
                        if (j + 1 < csvRecord.length() && csvRecord.charAt(j + 1) == '\"') {
                            j += 2;
                            continue;
                        }
                        ++j;
                        closingQuote = true;
                        break;
                    }
                    ++j;
                }
                if (!closingQuote) {
                    throw new IllegalArgumentException("No closing quote found.");
                }
                if (j < csvRecord.length() && csvRecord.charAt(j) != this.separator) {
                    throw new IllegalArgumentException("The given csvRecord is invalid [RFC 4180].");
                }
                String value = i + 1 < j - 1 ? csvRecord.substring(i + 1, j - 1) : null;
                values.add(value != null ? this.unescape(value) : null);
                i = j + 1;
                continue;
            }
            if (csvRecord.charAt(i) == this.separator) {
                values.add(null);
                ++i;
                continue;
            }
            j = csvRecord.indexOf(this.separator, i + 1);
            String value = j >= 0 ? csvRecord.substring(i, j) : csvRecord.substring(i);
            values.add(this.unescape(value));
            i = j >= 0 ? j + 1 : csvRecord.length() + 1;
        }
        return values.toArray(new String[values.size()]);
    }

    protected String unescape(String value) {
        if (value.isEmpty()) {
            return null;
        }
        if ("null".equals(value)) {
            return null;
        }
        if (!this.escCrLf) {
            return value;
        }
        StringBuilder out = new StringBuilder(value.length());
        boolean crlf = false;
        for (int i = 0; i < value.length(); ++i) {
            char nc;
            char c = value.charAt(i);
            if (c != '\\') {
                out.append(c);
                continue;
            }
            if (i + 1 >= value.length() || (nc = value.charAt(i + 1)) != 'r' && nc != 'n') continue;
            out.append(nc == 'r' ? (char)'\r' : '\n');
            ++i;
            crlf = true;
        }
        return crlf ? out.toString() : value;
    }
}

