/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.utils.SplitUtils;
import java.nio.charset.StandardCharsets;
import java.util.Locale;

public class CharsetUtils {
    public static String parseCharset(String contentType) {
        if (contentType == null) {
            return StandardCharsets.UTF_8.name();
        }
        return CharsetUtils.parseCharset(contentType, StandardCharsets.UTF_8.name());
    }

    public static String parseCharset(String contentType, String defaultValue) {
        if (contentType == null) {
            return defaultValue;
        }
        String[] items = SplitUtils.split(contentType, ';');
        for (int i = items.length - 1; i >= 0; --i) {
            String item = items[i];
            if (!item.toLowerCase(Locale.ENGLISH).startsWith("charset=")) continue;
            return item.substring(8);
        }
        return defaultValue;
    }
}

