/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.utils.ArrayUtils;
import com.appslandia.common.utils.RandomUtils;
import com.appslandia.common.utils.ValueUtils;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CharUtils {
    private static final Pattern CHAR_RANGE_PATTERN = Pattern.compile(".\\-.");

    public static char[] toCharRanges(String charRanges) {
        Matcher matcher = CHAR_RANGE_PATTERN.matcher(charRanges);
        char[] chars = null;
        int lastEnd = 0;
        while (matcher.find()) {
            char to;
            String range = matcher.group();
            if (matcher.start() != lastEnd) {
                char[] notRange = charRanges.substring(lastEnd, matcher.start()).toCharArray();
                chars = chars == null ? notRange : ArrayUtils.append(chars, notRange);
            }
            lastEnd = matcher.end();
            char from = range.charAt(0);
            if (from > (to = range.charAt(2))) {
                throw new IllegalArgumentException("invalid charRanges (value=" + charRanges + ")");
            }
            char[] newChars = new char[to - from + 1];
            for (int i = 0; i < newChars.length; ++i) {
                newChars[i] = (char)(from + i);
            }
            chars = chars == null ? newChars : ArrayUtils.append(chars, newChars);
        }
        if (lastEnd < charRanges.length()) {
            char[] notRange = charRanges.substring(lastEnd).toCharArray();
            chars = chars == null ? notRange : ArrayUtils.append(chars, notRange);
        }
        return chars;
    }

    public static char[] randomChars(int len, char[][] sources, Random random) {
        int rdCount;
        char[] rdChars = new char[len];
        int avgLen = ValueUtils.valueOrMin(len / sources.length, 1);
        int size = 0;
        for (int srcIndex = 0; srcIndex < sources.length && size < len; size += rdCount, ++srcIndex) {
            rdCount = RandomUtils.nextInt(1, avgLen, random);
            for (int i = 0; i < rdCount; ++i) {
                rdChars[size + i] = sources[srcIndex][random.nextInt(sources[srcIndex].length)];
            }
        }
        if (size < len) {
            for (int i = 0; i < len; ++i) {
                if (rdChars[i] != '\u0000') continue;
                int srcIndex = random.nextInt(sources.length);
                rdChars[i] = sources[srcIndex][random.nextInt(sources[srcIndex].length)];
            }
        }
        ArrayUtils.shuffle(rdChars, random);
        return rdChars;
    }
}

