/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.StringUtils;
import java.util.Locale;
import java.util.regex.Pattern;

public class BytesSizeUtils {
    private static final Pattern BYTES_SIZE_PATTERN = Pattern.compile("((\\d+.\\d+|\\d+)(TB|GB|MB|KB|B)\\s*)+", 2);

    public static long translateToBytes(String sizeAmt) throws IllegalArgumentException {
        return BytesSizeUtils.translateToBytes(sizeAmt, false);
    }

    public static long translateToBytes(String sizeAmt, boolean base10) throws IllegalArgumentException {
        sizeAmt = StringUtils.trimToNull(sizeAmt);
        AssertUtils.assertNotNull(sizeAmt, "sizeAmt is required.");
        if (!BYTES_SIZE_PATTERN.matcher(sizeAmt).matches()) {
            throw new IllegalArgumentException("sizeAmt is invalid (value=" + sizeAmt + ")");
        }
        double result = 0.0;
        int i = 0;
        while (i < sizeAmt.length()) {
            String unit;
            int k;
            int j = i;
            while (Character.isDigit(sizeAmt.charAt(j)) || sizeAmt.charAt(j) == '.') {
                ++j;
            }
            for (k = j; k <= sizeAmt.length() - 1 && (Character.isLetter(sizeAmt.charAt(k)) || sizeAmt.charAt(k) == ' '); ++k) {
            }
            double amt = Double.parseDouble(sizeAmt.substring(i, j));
            switch (unit = sizeAmt.substring(j, k).trim().toUpperCase(Locale.ENGLISH)) {
                case "GB": {
                    result += amt * (double)(base10 ? 1000000000 : 0x40000000);
                    break;
                }
                case "MB": {
                    result += amt * (double)(base10 ? 1000000 : 0x100000);
                    break;
                }
                case "KB": {
                    result += amt * (double)(base10 ? 1000 : 1024);
                    break;
                }
                default: {
                    result += amt;
                }
            }
            i = k;
        }
        return (long)Math.ceil(result);
    }
}

