/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.utils.CharUtils;
import java.util.BitSet;

public class BitMap
extends BitSet {
    private static final long serialVersionUID = 1L;

    public BitMap() {
    }

    public BitMap(int bits) {
        super(bits);
    }

    public BitMap(BitSet bitSet) {
        super(bitSet.size());
        this.or(bitSet);
    }

    public BitMap on(int fromIdx, int toIdxExclusive) {
        this.set(fromIdx, toIdxExclusive);
        return this;
    }

    public BitMap on(int ... indexes) {
        for (int index : indexes) {
            this.set(index);
        }
        return this;
    }

    public BitMap on(String charRangles) {
        for (char chr : CharUtils.toCharRanges(charRangles)) {
            this.set(chr);
        }
        return this;
    }

    public BitMap off(int fromIdx, int toIdxExclusive) {
        this.clear(fromIdx, toIdxExclusive);
        return this;
    }

    public BitMap off(int ... indexes) {
        for (int index : indexes) {
            this.clear(index);
        }
        return this;
    }

    public BitMap off(String charRangles) {
        for (char chr : CharUtils.toCharRanges(charRangles)) {
            this.clear(chr);
        }
        return this;
    }

    public BitMap toggle(int fromIdx, int toIdxExclusive) {
        this.flip(fromIdx, toIdxExclusive);
        return this;
    }

    public BitMap toggle(int ... indexes) {
        for (int index : indexes) {
            this.flip(index);
        }
        return this;
    }

    public BitMap toggle(String charRangles) {
        for (char chr : CharUtils.toCharRanges(charRangles)) {
            this.flip(chr);
        }
        return this;
    }

    public BitMap copy() {
        BitMap impl = new BitMap(this.size());
        impl.or(this);
        return impl;
    }
}

