/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.utils.StringUtils;
import java.util.Collection;
import java.util.function.Supplier;

public class AssertUtils {
    public static void assertTrue(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void assertTrue(boolean expression, String errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static void assertTrue(boolean expression, Supplier<String> errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(errorMessage.get());
        }
    }

    public static void assertFalse(boolean expression) {
        if (expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void assertFalse(boolean expression, String errorMessage) {
        if (expression) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static void assertFalse(boolean expression, Supplier<String> errorMessage) {
        if (expression) {
            throw new IllegalArgumentException(errorMessage.get());
        }
    }

    public static <T> T assertNotNull(T obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return obj;
    }

    public static <T> T assertNotNull(T obj, String errorMessage) {
        if (obj == null) {
            throw new NullPointerException(errorMessage);
        }
        return obj;
    }

    public static <T> T assertNotNull(T obj, Supplier<String> errorMessage) {
        if (obj == null) {
            throw new NullPointerException(errorMessage.get());
        }
        return obj;
    }

    public static void assertNull(Object obj) {
        if (obj != null) {
            throw new IllegalArgumentException();
        }
    }

    public static void assertNull(Object obj, String errorMessage) {
        if (obj != null) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static void assertNull(Object obj, Supplier<String> errorMessage) {
        if (obj != null) {
            throw new IllegalArgumentException(errorMessage.get());
        }
    }

    public static void assertState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    public static void assertState(boolean expression, String errorMessage) {
        if (!expression) {
            throw new IllegalStateException(errorMessage);
        }
    }

    public static void assertState(boolean expression, Supplier<String> errorMessage) {
        if (!expression) {
            throw new IllegalStateException(errorMessage.get());
        }
    }

    public static <T> T assertStateNotNull(T obj) {
        if (obj == null) {
            throw new IllegalStateException();
        }
        return obj;
    }

    public static <T> T assertStateNotNull(T obj, String errorMessage) {
        if (obj == null) {
            throw new IllegalStateException(errorMessage);
        }
        return obj;
    }

    public static <T> T assertStateNotNull(T obj, Supplier<String> errorMessage) {
        if (obj == null) {
            throw new IllegalStateException(errorMessage.get());
        }
        return obj;
    }

    public static void assertStateNull(Object obj) {
        if (obj != null) {
            throw new IllegalStateException();
        }
    }

    public static void assertStateNull(Object obj, String errorMessage) {
        if (obj != null) {
            throw new IllegalStateException(errorMessage);
        }
    }

    public static void assertStateNull(Object obj, Supplier<String> errorMessage) {
        if (obj != null) {
            throw new IllegalStateException(errorMessage.get());
        }
    }

    public static String assertNotBlank(String text) {
        if ((text = StringUtils.trimToNull(text)) == null) {
            throw new IllegalArgumentException();
        }
        return text;
    }

    public static String assertNotBlank(String text, String errorMessage) {
        if ((text = StringUtils.trimToNull(text)) == null) {
            throw new IllegalArgumentException(errorMessage);
        }
        return text;
    }

    public static String assertNotBlank(String text, Supplier<String> errorMessage) {
        if ((text = StringUtils.trimToNull(text)) == null) {
            throw new IllegalArgumentException(errorMessage.get());
        }
        return text;
    }

    public static <T> T[] assertHasElements(T[] elements) {
        if (elements == null || elements.length == 0) {
            throw new IllegalArgumentException();
        }
        return elements;
    }

    public static <T> T[] assertHasElements(T[] elements, String errorMessage) {
        if (elements == null || elements.length == 0) {
            throw new IllegalArgumentException(errorMessage);
        }
        return elements;
    }

    public static <T> T[] assertHasElements(T[] elements, Supplier<String> errorMessage) {
        if (elements == null || elements.length == 0) {
            throw new IllegalArgumentException(errorMessage.get());
        }
        return elements;
    }

    public static <T> Collection<T> assertHasElements(Collection<T> elements) {
        if (elements == null || elements.size() == 0) {
            throw new IllegalArgumentException();
        }
        return elements;
    }

    public static <T> Collection<T> assertHasElements(Collection<T> elements, String errorMessage) {
        if (elements == null || elements.size() == 0) {
            throw new IllegalArgumentException(errorMessage);
        }
        return elements;
    }

    public static <T> Collection<T> assertHasElements(Collection<T> elements, Supplier<String> errorMessage) {
        if (elements == null || elements.size() == 0) {
            throw new IllegalArgumentException(errorMessage.get());
        }
        return elements;
    }

    public static int assertPositive(int value) {
        if (value <= 0) {
            throw new IllegalArgumentException();
        }
        return value;
    }

    public static int assertPositive(int value, String errorMessage) {
        if (value <= 0) {
            throw new IllegalArgumentException(errorMessage);
        }
        return value;
    }

    public static int assertPositive(int value, Supplier<String> errorMessage) {
        if (value <= 0) {
            throw new IllegalArgumentException(errorMessage.get());
        }
        return value;
    }

    public static int assertNonNegative(int value) {
        if (value < 0) {
            throw new IllegalArgumentException();
        }
        return value;
    }

    public static int assertNonNegative(int value, String errorMessage) {
        if (value < 0) {
            throw new IllegalArgumentException(errorMessage);
        }
        return value;
    }

    public static int assertNonNegative(int value, Supplier<String> errorMessage) {
        if (value < 0) {
            throw new IllegalArgumentException(errorMessage.get());
        }
        return value;
    }

    public static long assertPositive(long value) {
        if (value <= 0L) {
            throw new IllegalArgumentException();
        }
        return value;
    }

    public static long assertPositive(long value, String errorMessage) {
        if (value <= 0L) {
            throw new IllegalArgumentException(errorMessage);
        }
        return value;
    }

    public static long assertPositive(long value, Supplier<String> errorMessage) {
        if (value <= 0L) {
            throw new IllegalArgumentException(errorMessage.get());
        }
        return value;
    }

    public static long assertNonNegative(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException();
        }
        return value;
    }

    public static long assertNonNegative(long value, String errorMessage) {
        if (value < 0L) {
            throw new IllegalArgumentException(errorMessage);
        }
        return value;
    }

    public static long assertNonNegative(long value, Supplier<String> errorMessage) {
        if (value < 0L) {
            throw new IllegalArgumentException(errorMessage.get());
        }
        return value;
    }

    public static double assertPositive(double value) {
        if (Double.compare(value, 0.0) <= 0) {
            throw new IllegalArgumentException();
        }
        return value;
    }

    public static double assertPositive(double value, String errorMessage) {
        if (Double.compare(value, 0.0) <= 0) {
            throw new IllegalArgumentException(errorMessage);
        }
        return value;
    }

    public static double assertPositive(double value, Supplier<String> errorMessage) {
        if (Double.compare(value, 0.0) <= 0) {
            throw new IllegalArgumentException(errorMessage.get());
        }
        return value;
    }

    public static double assertNonNegative(double value) {
        if (Double.compare(value, 0.0) < 0) {
            throw new IllegalArgumentException();
        }
        return value;
    }

    public static double assertNonNegative(double value, String errorMessage) {
        if (Double.compare(value, 0.0) < 0) {
            throw new IllegalArgumentException(errorMessage);
        }
        return value;
    }

    public static double assertNonNegative(double value, Supplier<String> errorMessage) {
        if (Double.compare(value, 0.0) < 0) {
            throw new IllegalArgumentException(errorMessage.get());
        }
        return value;
    }

    public static double assertNegative(double value) {
        if (Double.compare(value, 0.0) >= 0) {
            throw new IllegalArgumentException();
        }
        return value;
    }

    public static double assertNegative(double value, String errorMessage) {
        if (Double.compare(value, 0.0) >= 0) {
            throw new IllegalArgumentException(errorMessage);
        }
        return value;
    }

    public static double assertNegative(double value, Supplier<String> errorMessage) {
        if (Double.compare(value, 0.0) >= 0) {
            throw new IllegalArgumentException(errorMessage.get());
        }
        return value;
    }

    public static double assertNonPositive(double value) {
        if (Double.compare(value, 0.0) > 0) {
            throw new IllegalArgumentException();
        }
        return value;
    }

    public static double assertNonPositive(double value, String errorMessage) {
        if (Double.compare(value, 0.0) > 0) {
            throw new IllegalArgumentException(errorMessage);
        }
        return value;
    }

    public static double assertNonPositive(double value, Supplier<String> errorMessage) {
        if (Double.compare(value, 0.0) > 0) {
            throw new IllegalArgumentException(errorMessage.get());
        }
        return value;
    }
}

